/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.meta.mobs.monster;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.Metadata;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.types.MobMeta;

public class WitherMeta
extends MobMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 20;
    private int centerHead = -1;
    private int leftHead = -1;
    private int rightHead = -1;

    public WitherMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public void setCenterHead(int centerHead) {
        this.centerHead = centerHead;
        this.metadata.setIndex(WitherMeta.offset((byte)16, 0), EntityDataTypes.INT, centerHead == -1 ? 0 : centerHead);
    }

    public void setLeftHead(int leftHead) {
        this.leftHead = leftHead;
        this.metadata.setIndex(WitherMeta.offset((byte)16, 1), EntityDataTypes.INT, leftHead == -1 ? 0 : leftHead);
    }

    public void setRightHead(int rightHead) {
        this.rightHead = rightHead;
        this.metadata.setIndex(WitherMeta.offset((byte)16, 2), EntityDataTypes.INT, rightHead == -1 ? 0 : rightHead);
    }

    public int getCenterHead() {
        return this.centerHead;
    }

    public int getLeftHead() {
        return this.leftHead;
    }

    public int getRightHead() {
        return this.rightHead;
    }

    public int getInvulnerableTime() {
        return this.metadata.getIndex(WitherMeta.offset((byte)16, 3), 0);
    }

    public void setInvulnerableTime(int value) {
        this.metadata.setIndex(WitherMeta.offset((byte)16, 3), EntityDataTypes.INT, value);
    }
}

