/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.meta.other;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.EntityMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.Metadata;
import org.jetbrains.annotations.NotNull;

public class BoatMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 15;

    public BoatMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public int getTimeSinceLastHit() {
        return this.metadata.getIndex((byte)8, 0);
    }

    public void setTimeSinceLastHit(int value) {
        this.metadata.setIndex((byte)8, EntityDataTypes.INT, value);
    }

    public int getForwardDirection() {
        return this.metadata.getIndex(BoatMeta.offset((byte)8, 1), 1);
    }

    public void setForwardDirection(int value) {
        this.metadata.setIndex(BoatMeta.offset((byte)8, 1), EntityDataTypes.INT, value);
    }

    public float getDamageTaken() {
        return this.metadata.getIndex(BoatMeta.offset((byte)8, 2), 0).intValue();
    }

    public void setDamageTaken(float value) {
        this.metadata.setIndex(BoatMeta.offset((byte)8, 2), EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    @NotNull
    public Type getType() {
        return Type.VALUES[this.metadata.getIndex(BoatMeta.offset((byte)8, 3), 0)];
    }

    public void setType(@NotNull Type value) {
        this.metadata.setIndex(BoatMeta.offset((byte)8, 3), EntityDataTypes.INT, value.ordinal());
    }

    public boolean isLeftPaddleTurning() {
        return this.metadata.getIndex(BoatMeta.offset((byte)8, 4), false);
    }

    public void setLeftPaddleTurning(boolean value) {
        this.metadata.setIndex(BoatMeta.offset((byte)8, 4), EntityDataTypes.BOOLEAN, value);
    }

    public boolean isRightPaddleTurning() {
        return this.metadata.getIndex(BoatMeta.offset((byte)8, 5), false);
    }

    public void setRightPaddleTurning(boolean value) {
        this.metadata.setIndex(BoatMeta.offset((byte)8, 5), EntityDataTypes.BOOLEAN, value);
    }

    public int getSplashTimer() {
        return this.metadata.getIndex(BoatMeta.offset((byte)8, 6), 0);
    }

    public void setSplashTimer(int value) {
        this.metadata.setIndex(BoatMeta.offset((byte)8, 6), EntityDataTypes.INT, value);
    }

    public static enum Type {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

