/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.meta.types;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLib;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.Metadata;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.types.LivingEntityMeta;
import org.jetbrains.annotations.Nullable;

public class PlayerMeta
extends LivingEntityMeta {
    public static final byte OFFSET = 15;
    public static final byte MAX_OFFSET = 16;
    private static final byte CAPE_BIT = 1;
    private static final byte JACKET_BIT = 2;
    private static final byte LEFT_SLEEVE_BIT = 4;
    private static final byte RIGHT_SLEEVE_BIT = 8;
    private static final byte LEFT_LEG_BIT = 16;
    private static final byte RIGHT_LEG_BIT = 32;
    private static final byte HAT_BIT = 64;

    public PlayerMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public float getAdditionalHearts() {
        return this.metadata.getIndex((byte)15, Float.valueOf(0.0f)).floatValue();
    }

    public void setAdditionalHearts(float value) {
        this.metadata.setIndex((byte)15, EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public int getScore() {
        return this.metadata.getIndex(PlayerMeta.offset((byte)15, 1), 0);
    }

    public void setScore(int value) {
        this.metadata.setIndex(PlayerMeta.offset((byte)15, 1), EntityDataTypes.INT, value);
    }

    public boolean isCapeEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)1);
    }

    public void setCapeEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)1, value);
    }

    public boolean isJacketEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)2);
    }

    public void setJacketEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)2, value);
    }

    public boolean isLeftSleeveEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)4);
    }

    public void setLeftSleeveEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)4, value);
    }

    public boolean isRightSleeveEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)8);
    }

    public void setRightSleeveEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)8, value);
    }

    public boolean isLeftLegEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)16);
    }

    public void setLeftLegEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)16, value);
    }

    public boolean isRightLegEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)32);
    }

    public void setRightLegEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)32, value);
    }

    public boolean isHatEnabled() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit(PlayerMeta.offset((byte)15, 2), (byte)64);
    }

    public void setHatEnabled(boolean value) {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(PlayerMeta.offset((byte)15, 2), (byte)64, value);
    }

    public boolean isRightHandMain() {
        if (EntityLib.getApi().getPacketEvents().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
            return true;
        }
        return this.metadata.getIndex(PlayerMeta.offset((byte)15, 3), (byte)1) == 1;
    }

    public void setRightHandMain(boolean value) {
        if (EntityLib.getApi().getPacketEvents().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
            return;
        }
        this.metadata.setIndex(PlayerMeta.offset((byte)15, 3), EntityDataTypes.BYTE, (byte)(value ? 1 : 0));
    }

    @Nullable
    public NBTCompound getLeftShoulderData() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_11);
        return this.metadata.getIndex(PlayerMeta.offset((byte)15, 4), null);
    }

    public void setLeftShoulderData(@Nullable NBTCompound value) {
        if (value == null) {
            value = new NBTCompound();
        }
        this.metadata.setIndex(PlayerMeta.offset((byte)15, 4), EntityDataTypes.NBT, value);
    }

    @Nullable
    public NBTCompound getRightShoulderData() {
        PlayerMeta.isVersionNewer(ServerVersion.V_1_11);
        return this.metadata.getIndex(PlayerMeta.offset((byte)15, 5), null);
    }

    public void setRightShoulderData(@Nullable NBTCompound value) {
        if (value == null) {
            value = new NBTCompound();
        }
        this.metadata.setIndex(PlayerMeta.offset((byte)15, 5), EntityDataTypes.NBT, value);
    }
}

