/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.packetconversion;

import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPainting;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.other.PaintingMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.packetconversion.EntitySpawningMethod;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperLivingEntity;

final class LegacySpawningMethods {
    private LegacySpawningMethods() {
    }

    static class Painting
    implements EntitySpawningMethod {
        Painting() {
        }

        @Override
        public PacketWrapper<?> getSpawnPacket(WrapperEntity entity) {
            if (entity.getEntityMeta() instanceof PaintingMeta) {
                PaintingMeta paintingMeta = (PaintingMeta)entity.getEntityMeta();
                return new WrapperPlayServerSpawnPainting(entity.getEntityId(), entity.getUuid(), entity.getLocation().getPosition().toVector3i(), paintingMeta.getDirection());
            }
            throw new IllegalArgumentException("EntityMeta is not an instance of PaintingMeta");
        }
    }

    static class LivingEntity
    implements EntitySpawningMethod {
        LivingEntity() {
        }

        @Override
        public PacketWrapper<?> getSpawnPacket(WrapperEntity entity) {
            if (!(entity instanceof WrapperLivingEntity)) {
                throw new IllegalArgumentException("Entity is not an instance of WrapperLivingEntity");
            }
            return new WrapperPlayServerSpawnLivingEntity(entity.getEntityId(), entity.getUuid(), entity.getEntityType(), entity.getLocation().getPosition(), entity.getLocation().getYaw(), entity.getLocation().getPitch(), entity.getLocation().getPitch(), entity.createVeloPacket().get(), entity.getEntityMeta().entityData());
        }
    }

    static class Generic
    implements EntitySpawningMethod {
        Generic() {
        }

        @Override
        public PacketWrapper<?> getSpawnPacket(WrapperEntity entity) {
            return null;
        }
    }
}

