/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.spigot;

import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import de.vectorflare.skyboxengine.shaded.entitylib.APIConfig;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLib;
import de.vectorflare.skyboxengine.shaded.entitylib.TrackedEntity;
import de.vectorflare.skyboxengine.shaded.entitylib.common.AbstractPlatform;
import de.vectorflare.skyboxengine.shaded.entitylib.spigot.InternalRegistryListener;
import de.vectorflare.skyboxengine.shaded.entitylib.spigot.SpigotEntity;
import de.vectorflare.skyboxengine.shaded.entitylib.spigot.SpigotEntityLibAPI;
import de.vectorflare.skyboxengine.shaded.entitylib.utils.ConcurrentWeakIdentityHashMap;
import io.github.retrooper.packetevents.bstats.bukkit.Metrics;
import io.github.retrooper.packetevents.bstats.charts.CustomChart;
import io.github.retrooper.packetevents.bstats.charts.SimplePie;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpigotEntityLibPlatform
extends AbstractPlatform<JavaPlugin> {
    private SpigotEntityLibAPI api;
    private final Map<Integer, Entity> platformEntities = new ConcurrentWeakIdentityHashMap<Integer, Entity>();

    public SpigotEntityLibPlatform(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void setupApi(@NotNull APIConfig settings) {
        super.setupApi(settings);
        this.logger = settings.shouldUsePlatformLogger() ? ((JavaPlugin)this.handle).getLogger() : Logger.getLogger("EntityLib");
        this.api = new SpigotEntityLibAPI(this, settings);
        this.api.onLoad();
        this.api.onEnable();
        if (settings.shouldTrackPlatformEntities()) {
            InternalRegistryListener listener = new InternalRegistryListener(this);
            ((JavaPlugin)this.handle).getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this.handle);
            this.api.getPacketEvents().getEventManager().registerListener((PacketListenerCommon)listener);
        }
        if (settings.shouldUseBstats()) {
            PacketEventsAPI<?> pe = this.api.getPacketEvents();
            Metrics metrics = new Metrics((Plugin)pe.getPlugin(), 21916);
            metrics.addCustomChart((CustomChart)new SimplePie("entitylib-version", () -> EntityLib.getVersion().toString()));
        }
    }

    Map<Integer, Entity> getPlatformEntities() {
        return this.platformEntities;
    }

    @Override
    @NotNull
    public Stream<TrackedEntity> queryPlatformEntities() {
        if (!this.api.getSettings().shouldTrackPlatformEntities()) {
            return Stream.of(new TrackedEntity[0]);
        }
        return this.platformEntities.values().stream().map(SpigotEntity::new);
    }

    @Override
    @Nullable
    public TrackedEntity findPlatformEntity(int entityId) {
        if (!this.api.getSettings().shouldTrackPlatformEntities()) {
            return null;
        }
        for (World world : Bukkit.getWorlds()) {
            Entity e = world.getEntities().stream().filter(entity -> entity.getEntityId() == entityId).findFirst().orElse(null);
            if (e == null) continue;
            return new SpigotEntity(e);
        }
        return null;
    }

    public SpigotEntityLibAPI getAPI() {
        return this.api;
    }

    @Override
    public String getName() {
        return "Spigot";
    }
}

