/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper;

import com.github.retrooper.packetevents.protocol.attribute.Attribute;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public final class WrapperEntityAttributes {
    public static final WrapperPlayServerUpdateAttributes.PropertyModifier.Operation ADDITION = WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.ADDITION;
    public static final WrapperPlayServerUpdateAttributes.PropertyModifier.Operation MULTIPLY_BASE = WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.MULTIPLY_BASE;
    public static final WrapperPlayServerUpdateAttributes.PropertyModifier.Operation MULTIPLY_TOTAL = WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.MULTIPLY_TOTAL;
    private final WrapperEntity entity;
    private final List<WrapperPlayServerUpdateAttributes.Property> properties;

    public WrapperEntityAttributes(WrapperEntity entity) {
        this.entity = entity;
        this.properties = new CopyOnWriteArrayList<WrapperPlayServerUpdateAttributes.Property>();
    }

    public void setAttribute(Attribute attribute, double value, List<WrapperPlayServerUpdateAttributes.PropertyModifier> modifiers) {
        this.properties.stream().filter(property -> property.getAttribute() == attribute).findFirst().ifPresent(this.properties::remove);
        this.properties.add(new WrapperPlayServerUpdateAttributes.Property(attribute, value, modifiers));
        this.refresh();
    }

    public void setAttribute(Attribute attribute, double value, WrapperPlayServerUpdateAttributes.PropertyModifier modifier) {
        this.setAttribute(attribute, value, Collections.singletonList(modifier));
    }

    public void setAttribute(Attribute attribute, double value) {
        this.setAttribute(attribute, value, Collections.emptyList());
    }

    public List<WrapperPlayServerUpdateAttributes.Property> getProperties() {
        return new ArrayList<WrapperPlayServerUpdateAttributes.Property>(this.properties);
    }

    public void forEach(Consumer<WrapperPlayServerUpdateAttributes.Property> action) {
        this.properties.forEach(action);
    }

    public void clear() {
        this.properties.clear();
        this.refresh();
    }

    public void removeAttribute(Attribute attribute, WrapperPlayServerUpdateAttributes.PropertyModifier modifier) {
        this.properties.stream().filter(property -> property.getAttribute() == attribute).findFirst().ifPresent(property -> {
            property.getModifiers().remove(modifier);
            if (property.getModifiers().isEmpty()) {
                this.properties.remove(property);
            }
        });
        this.refresh();
    }

    public void removeAttribute(Attribute attribute) {
        this.properties.stream().filter(property -> property.getAttribute() == attribute).findFirst().ifPresent(this.properties::remove);
        this.refresh();
    }

    public void refresh() {
        if (this.entity.isSpawned()) {
            this.entity.sendPacketToViewers((PacketWrapper<?>)this.createPacket());
        }
    }

    public WrapperPlayServerUpdateAttributes createPacket() {
        return new WrapperPlayServerUpdateAttributes(this.entity.getEntityId(), this.properties);
    }
}

