/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper;

import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLib;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.EntityMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class WrapperExperienceOrbEntity
extends WrapperEntity {
    private short experience;
    private Location slideTowards;

    public WrapperExperienceOrbEntity(int entityId, @NotNull UUID uuid, EntityType entityType, EntityMeta meta) {
        super(entityId, uuid, entityType, meta);
    }

    public WrapperExperienceOrbEntity(int entityId, @NotNull UUID uuid, EntityType entityType) {
        this(entityId, uuid, entityType, EntityMeta.createMeta(entityId, entityType));
    }

    public WrapperExperienceOrbEntity(int entityId, EntityType entityType) {
        this(entityId, EntityLib.getPlatform().getEntityUuidProvider().provide(entityType), entityType);
    }

    public WrapperExperienceOrbEntity(UUID uuid, EntityType entityType) {
        this(EntityLib.getPlatform().getEntityIdProvider().provide(uuid, entityType), uuid, entityType);
    }

    public WrapperExperienceOrbEntity(EntityType entityType) {
        this(EntityLib.getPlatform().getEntityUuidProvider().provide(entityType), entityType);
    }

    @Override
    public void tick(long time) {
        super.tick(time);
        if (this.hasNoGravity()) {
            this.setVelocity(this.getVelocity().add(0.0, (double)-0.3f, 0.0));
        }
        double d2 = 8.0;
        Vector3d distance = new Vector3d(this.slideTowards.getX() - this.getX(), this.slideTowards.getY() - this.getY(), this.slideTowards.getZ() - this.getZ());
        double length = distance.length();
        if (length < 8.0) {
            double f = 1.0 - length / 8.0;
            this.setVelocity(this.getVelocity().add(distance.normalize().multiply(f * f * 0.1)));
        }
        float g = 0.98f;
        if (this.isOnGround()) {
            g = 0.58800006f;
        }
        this.setVelocity(this.getVelocity().multiply((double)g, (double)0.98f, (double)g));
        if (this.isOnGround()) {
            this.setVelocity(this.getVelocity().multiply(1.0, (double)-0.9f, 1.0));
        }
    }

    public Location getSlideTowards() {
        return this.slideTowards;
    }

    public void setSlideTowards(Location slideTowards) {
        this.slideTowards = slideTowards;
    }

    public short getExperience() {
        return this.experience;
    }

    public void setExperience(short experience) {
        this.getViewers().forEach(this::removeViewer);
        this.experience = experience;
        this.getViewers().forEach(this::addViewer);
    }
}

