/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper.ai;

import de.vectorflare.skyboxengine.shaded.entitylib.tick.Tickable;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.ai.GoalSelector;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.ai.GoalSelectorList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AIGroup
implements Tickable {
    private final List<GoalSelector> goalSelectors = new GoalSelectorList(this);
    private GoalSelector currentGoalSelector;
    private boolean ticking = true;

    @NotNull
    public Collection<GoalSelector> getGoalSelectors() {
        return this.goalSelectors;
    }

    @Nullable
    public GoalSelector getCurrentGoal() {
        return this.currentGoalSelector;
    }

    public void addGoalSelector(@NotNull GoalSelector goalSelector) {
        this.goalSelectors.add(goalSelector);
    }

    public void setCurrentGoal(@Nullable GoalSelector goalSelector) {
        if (goalSelector != null && goalSelector.getAIGroup() != this) {
            throw new IllegalArgumentException("GoalSelector is not in this AIGroup");
        }
        this.currentGoalSelector = goalSelector;
    }

    @Override
    public boolean isTicking() {
        return this.ticking;
    }

    @Override
    public void setTicking(boolean ticking) {
        this.ticking = ticking;
    }

    @Override
    public void tick(long time) {
        GoalSelector currentGoalSelector = this.getCurrentGoal();
        if (currentGoalSelector != null && currentGoalSelector.shouldEnd()) {
            currentGoalSelector.end();
            currentGoalSelector = null;
            this.setCurrentGoal(null);
        }
        for (GoalSelector selector : this.getGoalSelectors()) {
            if (selector == currentGoalSelector) break;
            if (!selector.shouldStart()) continue;
            if (currentGoalSelector != null) {
                currentGoalSelector.end();
            }
            currentGoalSelector = selector;
            this.setCurrentGoal(currentGoalSelector);
            currentGoalSelector.start();
            break;
        }
        if (currentGoalSelector != null) {
            currentGoalSelector.tick(time);
        }
    }
}

