/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper.ai.goals;

import com.github.retrooper.packetevents.util.Vector3d;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.CoordinateUtil;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntityCreature;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.ai.GoalSelector;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class RandomHeadMovementGoal
extends GoalSelector {
    private static final Random RANDOM = new Random();
    private final int chancePerTick;
    private final Supplier<Integer> minimalLookTimeSupplier;
    private final Function<WrapperEntityCreature, Vector3d> randomDirectionFunction;
    private Vector3d lookDirection;
    private int lookTime = 0;

    public RandomHeadMovementGoal(WrapperEntityCreature entityCreature, int chancePerTick) {
        this(entityCreature, chancePerTick, () -> 20 + RANDOM.nextInt(20), creature -> {
            double n = Math.PI * 2 * RANDOM.nextDouble();
            return new Vector3d((double)((float)Math.cos(n)), 0.0, (double)((float)Math.sin(n)));
        });
    }

    public RandomHeadMovementGoal(WrapperEntityCreature entityCreature, int chancePerTick, @NotNull Supplier<Integer> minimalLookTimeSupplier, @NotNull Function<WrapperEntityCreature, Vector3d> randomDirectionFunction) {
        super(entityCreature);
        this.chancePerTick = chancePerTick;
        this.minimalLookTimeSupplier = minimalLookTimeSupplier;
        this.randomDirectionFunction = randomDirectionFunction;
    }

    @Override
    public boolean shouldStart() {
        return RANDOM.nextInt(this.chancePerTick) == 0;
    }

    @Override
    public void start() {
        this.lookTime = this.minimalLookTimeSupplier.get();
        this.lookDirection = this.randomDirectionFunction.apply(this.entity);
    }

    @Override
    public void tick(long time) {
        --this.lookTime;
        this.entity.teleport(CoordinateUtil.withDirection(this.entity.getLocation(), this.lookDirection), this.entity.isOnGround());
    }

    @Override
    public boolean shouldEnd() {
        return this.lookTime < 0;
    }

    @Override
    public void end() {
    }
}

