/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram;

import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.Location;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.display.TextDisplayMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram.LegacyHologram;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram.ModernHologram;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Hologram {
    public static @NotNull Legacy legacy(@NotNull Location location) {
        return new LegacyHologram(location);
    }

    public static @NotNull Legacy legacy(@NotNull Location location, List<Component> lines) {
        return new LegacyHologram(location, lines);
    }

    public static @NotNull Modern modern(@NotNull Location location) {
        return new ModernHologram(location);
    }

    public static @NotNull Modern modern(@NotNull Location location, List<Component> lines) {
        return new ModernHologram(location, lines);
    }

    @NotNull
    public Location getLocation();

    public void show();

    public void hide();

    public void teleport(Location var1);

    @Nullable
    public Component getLine(int var1);

    public int length();

    public void setLine(int var1, @Nullable Component var2);

    public void addLine(@Nullable Component var1);

    public void addViewer(@NotNull UUID var1);

    default public void addViewer(@NotNull User user) {
        this.addViewer(user.getUUID());
    }

    public static interface Legacy
    extends Hologram {
        public float getLineOffset(boolean var1);

        public void setLineOffset(boolean var1, float var2);

        default public float getLineOffset() {
            return this.getLineOffset(false);
        }

        default public void setLineOffset(float value) {
            this.setLineOffset(false, value);
        }

        public boolean isMarker();

        public void setMarker(boolean var1);
    }

    public static interface Modern
    extends Hologram {
        public void setModifier(@NotNull Consumer<TextDisplayMeta> var1);
    }
}

