/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram;

import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.world.Location;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.other.ArmorStandMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.utils.Check;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram.Hologram;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LegacyHologram
implements Hologram.Legacy {
    private Location location;
    private final List<WrapperEntity> lines = new ArrayList<WrapperEntity>(3);
    private float lineOffset = -0.9875f;
    private float markerOffset = -0.40625f;
    private boolean marker;

    LegacyHologram(@NotNull Location location) {
        this.location = location;
    }

    LegacyHologram(@NotNull Location location, List<Component> lines) {
        this(location);
        for (Component line : lines) {
            this.addLine(line);
        }
    }

    @Override
    public void addViewer(@NotNull UUID viewer) {
        for (WrapperEntity line : this.lines) {
            line.addViewer(viewer);
        }
    }

    @Override
    public boolean isMarker() {
        return this.marker;
    }

    @Override
    public void setMarker(boolean marker) {
        this.marker = true;
        if (this.lines.isEmpty()) {
            return;
        }
        this.teleport(this.location);
    }

    @Override
    public void show() {
        for (WrapperEntity line : this.lines) {
            line.spawn(this.location);
        }
        this.teleport(this.location);
    }

    @Override
    public void hide() {
        for (WrapperEntity line : this.lines) {
            line.despawn();
        }
    }

    @Override
    public void teleport(Location location) {
        this.location = location;
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            WrapperEntity line = this.lines.get(i);
            double y = this.marker ? location.getY() + (double)this.markerOffset : location.getY() + (double)((float)i * this.lineOffset);
            ArmorStandMeta meta = (ArmorStandMeta)line.getEntityMeta();
            meta.setMarker(this.marker);
            Location l = new Location(location.getX(), y, location.getZ(), location.getYaw(), location.getPitch());
            line.teleport(l, false);
        }
    }

    @Override
    @Nullable
    public Component getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return null;
        }
        return this.lines.get(index).getEntityMeta().getCustomName();
    }

    @Override
    public void setLine(int index, @Nullable Component line) {
        WrapperEntity e = new WrapperEntity(EntityTypes.ARMOR_STAND);
        e.spawn(this.location);
        ArmorStandMeta meta = (ArmorStandMeta)e.getEntityMeta();
        meta.setCustomName(line);
        meta.setCustomNameVisible(true);
        meta.setInvisible(true);
        meta.setHasNoGravity(true);
        meta.setSmall(true);
        meta.setMarker(this.marker);
        Check.arrayLength(this.lines, index, e);
        e.spawn(this.location);
        this.teleport(this.location);
    }

    @Override
    public void addLine(@Nullable Component line) {
        this.setLine(this.lines.size(), line);
    }

    @Override
    public float getLineOffset(boolean marker) {
        return marker ? this.markerOffset : this.lineOffset;
    }

    @Override
    public int length() {
        return this.lines.size();
    }

    @Override
    public void setLineOffset(boolean marker, float value) {
        if (marker) {
            this.markerOffset = value;
        } else {
            this.lineOffset = value;
        }
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }
}

