/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram;

import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.world.Location;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.display.TextDisplayMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.utils.Check;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.hologram.Hologram;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ModernHologram
implements Hologram.Modern {
    private Location location;
    private final List<WrapperEntity> lines = new ArrayList<WrapperEntity>(3);
    private Consumer<TextDisplayMeta> modifier;
    private boolean spawned = false;

    ModernHologram(@NotNull Location location) {
        this.location = location;
    }

    ModernHologram(@NotNull Location location, List<Component> lines) {
        this(location);
        for (Component line : lines) {
            this.addLine(line);
        }
    }

    @Override
    public void show() {
        for (WrapperEntity line : this.lines) {
            line.spawn(this.location);
        }
        this.teleport(this.location);
        this.spawned = true;
    }

    @Override
    public void hide() {
        for (WrapperEntity line : this.lines) {
            line.despawn();
        }
        this.spawned = false;
    }

    @Override
    public void teleport(Location location) {
        this.location = location;
        if (this.lines.isEmpty()) {
            return;
        }
        WrapperEntity first = this.lines.get(0);
        first.teleport(location);
        for (WrapperEntity e : this.lines) {
            if (e.getUuid().equals(first.getUuid())) continue;
            first.addPassenger(e);
        }
    }

    @Override
    @Nullable
    public Component getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return null;
        }
        return this.lines.get(index).getEntityMeta().getCustomName();
    }

    @Override
    public void setLine(int index, @Nullable Component line) {
        WrapperEntity e = new WrapperEntity(EntityTypes.TEXT_DISPLAY);
        e.spawn(this.location);
        TextDisplayMeta meta = (TextDisplayMeta)e.getEntityMeta();
        meta.setInvisible(true);
        meta.setHasNoGravity(true);
        meta.setText(line);
        if (this.modifier != null) {
            this.modifier.accept(meta);
        }
        Check.arrayLength(this.lines, index, e);
        if (this.spawned) {
            e.spawn(this.location);
            this.teleport(this.location);
        }
    }

    @Override
    public void addLine(@Nullable Component line) {
        this.setLine(this.lines.size(), line);
    }

    @Override
    public void addViewer(@NotNull UUID viewer) {
        for (WrapperEntity line : this.lines) {
            line.addViewer(viewer);
        }
    }

    @Override
    public int length() {
        return this.lines.size();
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setModifier(@NotNull Consumer<TextDisplayMeta> consumer) {
        this.modifier = consumer;
    }
}

