/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.skybox;

import de.vectorflare.skyboxengine.SkyboxEngine;
import de.vectorflare.skyboxengine.config.Settings;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import de.vectorflare.skyboxengine.tintcolor.TintProvider;
import de.vectorflare.skyboxengine.util.ConversionUtils;
import de.vectorflare.skyboxengine.util.ItemDisplays;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerSkybox {
    private final Player player;
    private final Settings.SkyboxSettings settings;
    private WrapperEntity skyboxEntity;
    private TintProvider tintProvider;

    private int getBaseSize() {
        return Math.min(this.player.getClientViewDistance(), this.player.getViewDistance()) * 16;
    }

    private int getSize() {
        return this.getBaseSize() * -4;
    }

    public static int getInterpolationDuration() {
        return 10;
    }

    private NamespacedKey getSkyboxModel() {
        return NamespacedKey.fromString((String)this.settings.getSkyboxId());
    }

    public Color getColor() {
        return Color.fromRGB((int)255, (int)255, (int)255);
    }

    public PlayerSkybox(Player player, Settings.SkyboxSettings settings) {
        this.player = player;
        this.settings = settings;
        String tintProviderKey = settings.getTintProvider();
        this.tintProvider = SkyboxEngine.getTintProviders().getTintProvider(tintProviderKey);
    }

    public void createSkybox() {
        Location spawn = this.player.getLocation();
        spawn.setPitch(0.0f);
        spawn.setYaw(0.0f);
        this.skyboxEntity = ItemDisplays.spawnVFX(new ItemStack(Material.LEATHER_HORSE_ARMOR), spawn, this.player);
        ItemDisplays.setDisplayModel(this.skyboxEntity, this.getSkyboxModel());
        ItemDisplays.setDisplaySize(this.skyboxEntity, this.getSize());
        ItemDisplays.setDisplayRenderDistance(this.skyboxEntity, 1000.0f);
        ItemDisplays.setDisplayColor(this.skyboxEntity, this.getColor());
    }

    public void tickSkybox() {
        Location spawn = this.player.getLocation();
        spawn.setPitch(0.0f);
        spawn.setYaw(0.0f);
        ItemDisplays.setDisplayModel(this.skyboxEntity, this.getSkyboxModel());
        ItemDisplays.setDisplaySize(this.skyboxEntity, this.getSize());
        ItemDisplays.setDisplayRenderDistance(this.skyboxEntity, 1000.0f);
        ItemDisplays.setDisplayTransformationInterpolation(this.skyboxEntity, PlayerSkybox.getInterpolationDuration());
        ItemDisplays.setDisplayTeleportInterpolation(this.skyboxEntity, PlayerSkybox.getInterpolationDuration());
        ItemDisplays.setDisplayColor(this.skyboxEntity, this.getColor());
        if (this.player.getLocation().distance(ConversionUtils.toBukkitLocation(this.skyboxEntity.getLocation(), this.player.getWorld())) > 100.0) {
            this.removeSkybox();
            this.createSkybox();
            return;
        }
        if (this.tintProvider != null) {
            ItemDisplays.setDisplayColor(this.skyboxEntity, this.tintProvider.getTintColor(this.player, this.settings));
        }
        ItemDisplays.teleportDisplay(this.skyboxEntity, spawn);
    }

    public void removeSkybox() {
        this.removeSkybox(0);
    }

    public void removeSkybox(int delay) {
        if (delay > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)SkyboxEngine.getInstance(), () -> this.skyboxEntity.remove(), (long)delay);
        } else {
            this.skyboxEntity.remove();
        }
    }

    @Generated
    public Settings.SkyboxSettings getSettings() {
        return this.settings;
    }

    @Generated
    public void setTintProvider(TintProvider tintProvider) {
        this.tintProvider = tintProvider;
    }
}

