/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.util;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ConversionUtils {
    public static Location toPacketEventsLocation(org.bukkit.Location bukkitLocation) {
        return new Location(bukkitLocation.getX(), bukkitLocation.getY(), bukkitLocation.getZ(), bukkitLocation.getYaw(), bukkitLocation.getPitch());
    }

    public static WrappedBlockState toPacketEventsBlockState(BlockData data) {
        return WrappedBlockState.getByString((String)data.getAsString());
    }

    public static Location toPacketEventsLocation(Vector3f packetEventsLocation, float yaw, float pitch) {
        return new Location((double)packetEventsLocation.getX(), (double)packetEventsLocation.getY(), (double)packetEventsLocation.getZ(), yaw, pitch);
    }

    public static Location toPacketEventsLocation(Vector3d packetEventsLocation, float yaw, float pitch) {
        return new Location(packetEventsLocation.getX(), packetEventsLocation.getY(), packetEventsLocation.getZ(), yaw, pitch);
    }

    public static org.bukkit.Location toBukkitLocation(Location packetEventsLocation, World world) {
        return new org.bukkit.Location(world, packetEventsLocation.getX(), packetEventsLocation.getY(), packetEventsLocation.getZ(), packetEventsLocation.getYaw(), packetEventsLocation.getPitch());
    }

    public static Vector toBukkitVector(Vector3f packetEventsVector) {
        return new Vector(packetEventsVector.getX(), packetEventsVector.getY(), packetEventsVector.getZ());
    }

    public static Vector toBukkitVector(Vector3d packetEventsVector) {
        return new Vector(packetEventsVector.getX(), packetEventsVector.getY(), packetEventsVector.getZ());
    }

    public static User toUser(Player player) {
        return PacketEvents.getAPI().getPlayerManager().getUser((Object)player);
    }

    public static Player toBukkitPlayer(User user) {
        try {
            return Bukkit.getPlayer((UUID)user.getProfile().getUUID());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static com.github.retrooper.packetevents.protocol.item.ItemStack toPacketEventsItemStack(ItemStack bukkitItemStack) {
        if (bukkitItemStack == null) {
            return com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY;
        }
        return SpigotConversionUtil.fromBukkitItemStack((ItemStack)bukkitItemStack);
    }

    public static ItemStack toBukkitItemStack(com.github.retrooper.packetevents.protocol.item.ItemStack packetEventsItemStack) {
        if (packetEventsItemStack == null || packetEventsItemStack.equals((Object)com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY)) {
            return new ItemStack(Material.AIR);
        }
        return SpigotConversionUtil.toBukkitItemStack((com.github.retrooper.packetevents.protocol.item.ItemStack)packetEventsItemStack);
    }
}

