/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.util;

import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerCamera;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.display.AbstractDisplayMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.display.ItemDisplayMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import de.vectorflare.skyboxengine.util.ConversionUtils;
import de.vectorflare.skyboxengine.util.Vector3fUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.util.Vector;

public class ItemDisplays {
    public static WrapperEntity spawnVFX(Collection<Player> users, ItemStack item, Location location) {
        WrapperEntity entity = new WrapperEntity(EntityTypes.ITEM_DISPLAY);
        ItemDisplayMeta meta = (ItemDisplayMeta)entity.getEntityMeta();
        meta.setItem(ConversionUtils.toPacketEventsItemStack(item));
        meta.setTransformationInterpolationDuration(5);
        meta.setPositionRotationInterpolationDuration(5);
        meta.setViewRange(1000.0f);
        meta.setBrightnessOverride(255);
        for (Player user : users) {
            entity.addViewer(ConversionUtils.toUser(user));
        }
        entity.spawn(ConversionUtils.toPacketEventsLocation(location));
        entity.refresh();
        return entity;
    }

    public static WrapperEntity spawnVFX(Player user, ItemStack item, Location location) {
        return ItemDisplays.spawnVFX(List.of(user), item, location);
    }

    public static WrapperEntity spawnVFX(ItemStack item, Location location, Collection<Player> users) {
        return ItemDisplays.spawnVFX(users, item, location);
    }

    public static WrapperEntity spawnVFX(ItemStack item, Location location, Player ... users) {
        return ItemDisplays.spawnVFX(Arrays.stream(users).toList(), item, location);
    }

    public static WrapperEntity spawnVFX(ItemStack item, Location location) {
        ArrayList<Player> players = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        return ItemDisplays.spawnVFX(players, item, location);
    }

    public static WrapperEntity spawnVFX(int modelId, Location location) {
        ArrayList<Player> players = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        WrapperEntity vfx = ItemDisplays.spawnVFX(players, location);
        ItemDisplays.setDisplayModel(vfx, modelId);
        return vfx;
    }

    public static WrapperEntity spawnVFX(Collection<Player> users, Location location) {
        return ItemDisplays.spawnVFX(users, new ItemStack(Material.ARMOR_STAND), location);
    }

    public static WrapperEntity spawnVFX(Player user, Location location) {
        return ItemDisplays.spawnVFX(List.of(user), new ItemStack(Material.ARMOR_STAND), location);
    }

    public static WrapperEntity spawnVFX(Location location) {
        return ItemDisplays.spawnVFX(new ItemStack(Material.AIR), location);
    }

    public static void setDisplayRenderDistance(WrapperEntity entity, float distance) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setViewRange(distance);
    }

    public static void setDisplayModel(WrapperEntity entity, int model) {
        ItemDisplayMeta meta = (ItemDisplayMeta)entity.getEntityMeta();
        ItemStack item = ConversionUtils.toBukkitItemStack(meta.getItem());
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(model));
        item.setItemMeta(itemMeta);
        meta.setItem(ConversionUtils.toPacketEventsItemStack(item));
    }

    public static void setDisplayModel(WrapperEntity entity, NamespacedKey model) {
        ItemDisplayMeta meta = (ItemDisplayMeta)entity.getEntityMeta();
        ItemStack item = ConversionUtils.toBukkitItemStack(meta.getItem());
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setItemModel(model);
        item.setItemMeta(itemMeta);
        meta.setItem(ConversionUtils.toPacketEventsItemStack(item));
    }

    public static void setDisplayModel(WrapperEntity entity, String model) {
        String[] elements = model.split(":");
        if (elements.length != 2) {
            return;
        }
        ItemDisplays.setDisplayModel(entity, new NamespacedKey(elements[0], elements[1]));
    }

    public static void setDisplaySize(WrapperEntity entity, Vector size) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setScale(Vector3fUtil.fromBukkitVector(size));
    }

    public static void setDisplaySize(WrapperEntity entity, float size) {
        ItemDisplays.setDisplaySize(entity, new Vector(size, size, size));
    }

    public static void setDisplaySize(WrapperEntity entity, float x, float y, float z) {
        ItemDisplays.setDisplaySize(entity, new Vector(x, y, z));
    }

    public static void setDisplayTranslation(WrapperEntity entity, Vector size) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setTranslation(Vector3fUtil.fromBukkitVector(size));
    }

    public static void setDisplayTranslation(WrapperEntity entity, float size) {
        ItemDisplays.setDisplayTranslation(entity, new Vector(size, size, size));
    }

    public static void setDisplayTranslation(WrapperEntity entity, float x, float y, float z) {
        ItemDisplays.setDisplayTranslation(entity, new Vector(x, y, z));
    }

    public static void setDisplayTeleportInterpolation(WrapperEntity entity, int interpolation) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setPositionRotationInterpolationDuration(interpolation);
    }

    public static void teleportDisplay(WrapperEntity entity, Location loc) {
        entity.teleport(ConversionUtils.toPacketEventsLocation(loc));
    }

    public static void setDisplayTransformationInterpolation(WrapperEntity entity, int interpolation) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setInterpolationDelay(0);
        meta.setTransformationInterpolationDuration(interpolation);
    }

    public static void setDisplayBrightness(WrapperEntity entity, int skyLight, int blockLight) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setBrightnessOverride(16 * skyLight + blockLight);
    }

    public static void setDisplayBrightness(WrapperEntity entity, int light) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setBrightnessOverride(16 * light);
    }

    public static void setDisplayGlowing(WrapperEntity entity, boolean glow) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setGlowing(glow);
    }

    public static void setDisplayGlowing(WrapperEntity entity, boolean glow, int color) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setGlowing(glow);
        meta.setGlowColorOverride(color);
    }

    public static void setDisplayGlowing(WrapperEntity entity, boolean glow, int r, int g, int b) {
        AbstractDisplayMeta meta = (AbstractDisplayMeta)entity.getEntityMeta();
        meta.setGlowing(glow);
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        meta.setGlowColorOverride(rgb);
    }

    public static void setDisplayColor(WrapperEntity entity, int r, int g, int b) {
        ItemDisplayMeta entityMeta = (ItemDisplayMeta)entity.getEntityMeta();
        ItemStack itemStack = ConversionUtils.toBukkitItemStack(entityMeta.getItem());
        LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
        meta.setColor(Color.fromRGB((int)r, (int)g, (int)b));
        itemStack.setItemMeta((ItemMeta)meta);
        entityMeta.setItem(ConversionUtils.toPacketEventsItemStack(itemStack));
    }

    public static void setDisplayColor(WrapperEntity entity, Color color) {
        ItemDisplayMeta entityMeta = (ItemDisplayMeta)entity.getEntityMeta();
        ItemStack itemStack = ConversionUtils.toBukkitItemStack(entityMeta.getItem());
        LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
        meta.setColor(color);
        itemStack.setItemMeta((ItemMeta)meta);
        entityMeta.setItem(ConversionUtils.toPacketEventsItemStack(itemStack));
    }

    public static void spectateDisplay(WrapperEntity entity) {
        WrapperPlayServerCamera camera = new WrapperPlayServerCamera(entity.getEntityId());
        entity.sendPacketToViewers((PacketWrapper<?>)camera);
    }
}

