/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.util;

import de.vectorflare.skyboxengine.SkyboxEngine;
import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TextOutputUtil {
    public static void broadcast(boolean usePrefix, String message) {
        String prefix = SkyboxEngine.getConfigInstance().getPrefix();
        String finalMessage = usePrefix ? prefix + " " + message : message;
        Bukkit.broadcast((Component)TextOutputUtil.MiniMessage(finalMessage));
    }

    public static void broadcast(String message) {
        Bukkit.broadcast((Component)TextOutputUtil.MiniMessage(message));
    }

    public static void sendMiniMessage(Player player, String message) {
        player.sendMessage(TextOutputUtil.MiniMessage(message));
    }

    public static void sendMiniMessageAsync(Player player, String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> player.sendMessage(TextOutputUtil.MiniMessage(message)));
    }

    public static void sendMiniMessage(Player player, boolean usePrefix, String message) {
        String prefix = SkyboxEngine.getConfigInstance().getPrefix();
        String finalMessage = usePrefix ? prefix + " " + message : message;
        player.sendMessage(TextOutputUtil.MiniMessage(finalMessage));
    }

    public static void sendMiniMessageAsync(Player player, boolean usePrefix, String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> {
            String prefix = SkyboxEngine.getConfigInstance().getPrefix();
            String finalMessage = usePrefix ? prefix + " " + message : message;
            player.sendMessage(TextOutputUtil.MiniMessage(finalMessage));
        });
    }

    public static void sendMiniMessage(CommandSender sender, String message) {
        sender.sendMessage(TextOutputUtil.MiniMessage(message));
    }

    public static void sendMiniMessageAsync(CommandSender sender, String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> sender.sendMessage(TextOutputUtil.MiniMessage(message)));
    }

    public static void sendMiniMessage(CommandSender sender, boolean usePrefix, String message) {
        String prefix = SkyboxEngine.getConfigInstance().getPrefix();
        String finalMessage = usePrefix ? prefix + " " + message : message;
        sender.sendMessage(TextOutputUtil.MiniMessage(finalMessage));
    }

    public static void sendMiniMessageAsync(CommandSender sender, boolean usePrefix, String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> {
            String prefix = SkyboxEngine.getConfigInstance().getPrefix();
            String finalMessage = usePrefix ? prefix + " " + message : message;
            sender.sendMessage(TextOutputUtil.MiniMessage(finalMessage));
        });
    }

    public static Component MiniMessage(String message) {
        return MiniMessage.miniMessage().deserialize(message, new TagResolver[]{Placeholder.parsed((String)"accent", (String)TextOutputUtil.miniColor(SkyboxEngine.getConfigInstance().getAccentColor())), Placeholder.parsed((String)"base", (String)TextOutputUtil.miniColor(SkyboxEngine.getConfigInstance().getBaseColor()))});
    }

    public static String miniColor(String color) {
        return "<color:" + color + ">";
    }

    public static String convertLegacyToMiniMessage(String legacyText) {
        LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().character('&').hexCharacter('#').extractUrls().build();
        TextComponent component = legacySerializer.deserialize(legacyText);
        return (String)MiniMessage.miniMessage().serialize((Component)component);
    }

    public static long toTicks(long seconds) {
        return seconds * 20L;
    }

    public static void sendTitle(Player player, String title, String subtitle, double fadein, double stay, double fadeout) {
        player.showTitle(Title.title((Component)TextOutputUtil.MiniMessage(title), (Component)TextOutputUtil.MiniMessage(subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)(fadein * 1000.0)), (Duration)Duration.ofMillis((long)(stay * 1000.0)), (Duration)Duration.ofMillis((long)(fadeout * 1000.0)))));
    }

    public static void sendTitleAsync(Player player, String title, String subtitle, double fadein, double stay, double fadeout) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> player.showTitle(Title.title((Component)TextOutputUtil.MiniMessage(title), (Component)TextOutputUtil.MiniMessage(subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)(fadein * 1000.0)), (Duration)Duration.ofMillis((long)(stay * 1000.0)), (Duration)Duration.ofMillis((long)(fadeout * 1000.0))))));
    }

    public static void sendTitle(Player player, String title, double fadein, double stay, double fadeout) {
        player.showTitle(Title.title((Component)TextOutputUtil.MiniMessage(title), (Component)TextOutputUtil.MiniMessage(""), (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)(fadein * 1000.0)), (Duration)Duration.ofMillis((long)(stay * 1000.0)), (Duration)Duration.ofMillis((long)(fadeout * 1000.0)))));
    }

    public static void sendTitleAsync(Player player, String title, double fadein, double stay, double fadeout) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> player.showTitle(Title.title((Component)TextOutputUtil.MiniMessage(title), (Component)TextOutputUtil.MiniMessage(""), (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)(fadein * 1000.0)), (Duration)Duration.ofMillis((long)(stay * 1000.0)), (Duration)Duration.ofMillis((long)(fadeout * 1000.0))))));
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        player.showTitle(Title.title((Component)TextOutputUtil.MiniMessage(title), (Component)TextOutputUtil.MiniMessage(subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L))));
    }

    public static void sendActionbar(Player player, String message) {
        player.sendActionBar(TextOutputUtil.MiniMessage(message));
    }

    public static void sendActionbarAsync(Player player, String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyboxEngine.getInstance(), () -> player.sendActionBar(TextOutputUtil.MiniMessage(message)));
    }
}

