/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.SignatureState;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeMinecraftProfileTexture;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.texture.FakeResourceLocation;
import customskinloader.profile.ModelManager0;
import customskinloader.utils.HttpTextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.SkinManager$SkinAvailableCallback;
import net.minecraft.util.ResourceLocation;

public class FakeSkinManager {
    public static void setSkinCacheDir(File skinCacheDirectory) {
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public static void setSkinCacheDir(Path skinCacheDirectory) {
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory.toFile();
    }

    public static Property createProperty(Property property) {
        return property == null ? new Property(null, null) : property;
    }

    public static Object[] createThreadDownloadImageData(ImmutableList<Object> list, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        Object[] params = list.toArray();
        if (profileTexture instanceof FakeMinecraftProfileTexture) {
            FakeMinecraftProfileTexture fakeProfileTexture = (FakeMinecraftProfileTexture)profileTexture;
            File cacheFile = fakeProfileTexture.getCacheFile();
            if (params.length == 4) {
                if (params[3] instanceof Boolean) {
                    if (((Boolean)params[3]).booleanValue()) {
                        params[0] = FakeResourceLocation.create((ResourceLocation)params[0], fakeProfileTexture);
                    }
                    params[1] = cacheFile.toPath();
                } else {
                    params[0] = cacheFile;
                    params[3] = new BaseBuffer((Runnable)params[3], textureType, fakeProfileTexture);
                }
            } else if (params.length == 5) {
                params[0] = cacheFile;
                params[3] = true;
                params[4] = new BaseBuffer((Runnable)params[4], textureType, fakeProfileTexture);
            }
        }
        return params;
    }

    public static void loadProfileTextures(Runnable runnable) {
        CustomSkinLoader.loadProfileTextures(runnable);
    }

    public static Executor loadProfileTextures(Executor executor) {
        return CustomSkinLoader.THREAD_POOL;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getUserProfile(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        return ModelManager0.fromUserProfile(CustomSkinLoader.loadProfile(profile));
    }

    public static void loadElytraTexture(SkinManager skinManager, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map, SkinManager$SkinAvailableCallback skinAvailableCallback) {
        for (int i = 2; i < MinecraftProfileTexture.Type.values().length; ++i) {
            MinecraftProfileTexture.Type type = MinecraftProfileTexture.Type.values()[i];
            if (!map.containsKey(type)) continue;
            skinManager.func_152789_a(map.get(type), type, skinAvailableCallback);
        }
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        return CustomSkinLoader.loadProfileFromCache(profile);
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        return FakeSkinManager.getUserProfile(sessionService, profile, requireSecure);
    }

    public static Object loadSkinFromCache(MinecraftSessionService sessionService, Property property, SkinManager.CacheKey cacheKey) {
        if (cacheKey instanceof FakeCacheKey) {
            return FakeCacheKey.createMinecraftProfileTextures(FakeSkinManager.loadSkinFromCache(sessionService, ((FakeCacheKey)cacheKey).profile(), false));
        }
        return sessionService.unpackTextures(property);
    }

    public static class FakeCacheKey
    extends SkinManager.CacheKey {
        private final GameProfile profile;

        public FakeCacheKey(UUID uuid, Property property, GameProfile profile) {
            super(uuid, property);
            this.profile = profile;
        }

        public GameProfile profile() {
            return this.profile;
        }

        public static SkinManager.CacheKey createFakeCacheKey(UUID uuid, Property property, GameProfile profile) {
            return new FakeCacheKey(uuid, property, profile);
        }

        public static Object createMinecraftProfileTextures(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures) {
            return new MinecraftProfileTextures(textures.get(MinecraftProfileTexture.Type.SKIN), textures.get(MinecraftProfileTexture.Type.CAPE), textures.get(MinecraftProfileTexture.Type.ELYTRA), SignatureState.SIGNED);
        }
    }

    public static class BaseBuffer
    implements IImageBuffer {
        private IImageBuffer buffer;
        private final Runnable callback;
        private final FakeMinecraftProfileTexture texture;

        public BaseBuffer(Runnable callback, MinecraftProfileTexture.Type type, FakeMinecraftProfileTexture texture) {
            this.callback = callback;
            this.texture = texture;
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer();
                }
            }
        }

        @Override
        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? this.buffer.func_195786_a(image) : image;
        }

        @Override
        public BufferedImage func_78432_a(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? this.buffer.func_78432_a(image) : image;
        }

        @Override
        public void func_152634_a() {
            if (this.buffer != null) {
                this.buffer.func_152634_a();
                if (this.buffer instanceof FakeSkinBuffer) {
                    BaseBuffer.judgeType(this.texture, () -> ((FakeSkinBuffer)this.buffer).judgeType());
                }
            }
            if (this.callback != null) {
                this.callback.run();
            }
        }

        public static void judgeType(FakeMinecraftProfileTexture texture, Supplier<String> type) {
            if (BaseBuffer.shouldJudgeType(texture)) {
                texture.setModel(type.get());
            }
        }

        private static boolean shouldJudgeType(FakeMinecraftProfileTexture texture) {
            return texture != null && "auto".equals(texture.getMetadata("model", false));
        }
    }
}

