/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake.texture;

import com.mojang.blaze3d.platform.NativeImage;
import customskinloader.fake.itf.FakeInterfaceManager;
import customskinloader.fake.texture.FakeImage;
import java.io.InputStream;

public class FakeNativeImage
implements FakeImage {
    private NativeImage image;
    private int ratio;

    public FakeNativeImage(int width, int height) {
        this(new NativeImage(width, height, true));
    }

    public FakeNativeImage(NativeImage image) {
        this.image = image;
    }

    public NativeImage getImage() {
        return this.image;
    }

    @Override
    public FakeImage createImage(int width, int height) {
        return new FakeNativeImage(width, height);
    }

    @Override
    public FakeImage createImage(InputStream is) {
        return new FakeNativeImage(NativeImage.read((InputStream)is));
    }

    @Override
    public int getRatio() {
        return this.ratio;
    }

    @Override
    public void setRatio(int ratio) {
        this.ratio = ratio;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getRGBA(int x, int y) {
        return FakeInterfaceManager.NativeImage_getPixel(this.image, x, y);
    }

    @Override
    public void setRGBA(int x, int y, int rgba) {
        FakeInterfaceManager.NativeImage_setPixel(this.image, x, y, rgba);
    }

    @Override
    public void copyImageData(FakeImage image) {
        if (!(image instanceof FakeNativeImage)) {
            return;
        }
        this.image.copyFrom(((FakeNativeImage)image).getImage());
    }

    @Override
    public void fillArea(int x0, int y0, int width, int height) {
        this.image.fillRect(x0, y0, width, height, 0);
    }

    @Override
    public void copyArea(int x0, int y0, int dx, int dy, int width, int height, boolean reversex, boolean reversey) {
        this.image.copyRect(x0, y0, dx, dy, width, height, reversex, reversey);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public static class Extended
    extends NativeImage {
        private final FakeNativeImage fakeImage;

        public static NativeImage create(FakeNativeImage fakeImage) {
            return new Extended(fakeImage);
        }

        public Extended(FakeNativeImage fakeImage) {
            super(fakeImage.getWidth(), fakeImage.getHeight(), true);
            this.copyFrom(fakeImage.getImage());
            this.fakeImage = fakeImage;
        }

        public FakeNativeImage getFakeImage() {
            return this.fakeImage;
        }
    }
}

