/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.forge;

import com.google.common.collect.ImmutableList;
import cpw.mods.cl.JarModuleFinder;
import cpw.mods.jarhandling.SecureJar;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class MixinConfigPlugin
extends customskinloader.mixin.core.MixinConfigPlugin {
    private static final MethodHandles.Lookup IMPL_LOOKUP = ((Supplier<MethodHandles.Lookup>)() -> {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            Object theUnsafe = theUnsafeField.get(null);
            Method getObjectMethod = unsafeClass.getMethod("getObject", Object.class, Long.TYPE);
            Method staticFieldBaseMethod = unsafeClass.getMethod("staticFieldBase", Field.class);
            Method staticFieldOffsetMethod = unsafeClass.getMethod("staticFieldOffset", Field.class);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            return (MethodHandles.Lookup)getObjectMethod.invoke(theUnsafe, staticFieldBaseMethod.invoke(theUnsafe, implLookupField), staticFieldOffsetMethod.invoke(theUnsafe, implLookupField));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }).get();

    private static void fixMixinModifyArgs() throws Throwable {
        String packageName;
        Map packageToOurModules;
        ClassLoader loader = MixinConfigPlugin.class.getClassLoader();
        Map<String, MethodHandle> handles = MixinConfigPlugin.findPackageLookup(loader.getClass());
        if (handles != null && handles.get("packageLookup") != null && (packageToOurModules = (Map)handles.get("packageLookup").invokeWithArguments(loader)).get(packageName = "org.spongepowered.asm.synthetic.args") == null) {
            Path moduleRoot = Paths.get("./CustomSkinLoader/FakeModule", new String[0]);
            Path classPath = Files.createDirectories(moduleRoot.resolve(packageName.replace('.', '/')), new FileAttribute[0]);
            Path classFile = classPath.resolve("package-info.class");
            if (!Files.exists(classFile, new LinkOption[0])) {
                Files.createFile(classFile, new FileAttribute[0]);
            }
            Configuration config = Configuration.resolve((ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[]{SecureJar.from((Path[])new Path[]{moduleRoot})}), (List<Configuration>)ImmutableList.of((Object)ModuleLayer.boot().configuration()), (ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[0]), (Collection<String>)ImmutableList.of((Object)"FakeModule"));
            ResolvedModule module = config.findModule("FakeModule").orElse(null);
            packageToOurModules.put(packageName, module);
            Object configuration = handles.get("configuration").invokeWithArguments(loader);
            HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>((Map)handles.get("nameToModuleGetter").invokeWithArguments(configuration));
            nameToModule.put("FakeModule", module);
            handles.get("nameToModuleSetter").invokeWithArguments(configuration, nameToModule);
            MethodHandle resolvedRootsGetter = handles.get("resolvedRoots");
            if (resolvedRootsGetter != null) {
                ((Map)resolvedRootsGetter.invokeWithArguments(loader)).put("FakeModule", module.reference());
            }
        }
    }

    private static Map<String, MethodHandle> findPackageLookup(Class<?> cl) throws Throwable {
        if (!ClassLoader.class.equals(cl)) {
            Field[] fields;
            HashMap<String, MethodHandle> map = new HashMap<String, MethodHandle>();
            for (Field field : fields = cl.getDeclaredFields()) {
                Type type = field.getGenericType();
                if (type instanceof ParameterizedType) {
                    ParameterizedType paramType = (ParameterizedType)type;
                    if (!Map.class.equals((Object)paramType.getRawType())) continue;
                    Class<?> classJarModuleReference = MixinConfigPlugin.findClass("cpw.mods.cl.JarModuleFinder$JarModuleReference");
                    if (Arrays.equals(new Class[]{String.class, ResolvedModule.class}, paramType.getActualTypeArguments())) {
                        map.put("packageLookup", IMPL_LOOKUP.findGetter(cl, field.getName(), field.getType()));
                        continue;
                    }
                    if (!Arrays.equals(new Class[]{String.class, classJarModuleReference}, paramType.getActualTypeArguments())) continue;
                    map.put("resolvedRoots", IMPL_LOOKUP.findGetter(cl, field.getName(), field.getType()));
                    continue;
                }
                if (!Configuration.class.equals(field.getType())) continue;
                map.put("configuration", IMPL_LOOKUP.findGetter(cl, field.getName(), field.getType()));
                map.put("nameToModuleGetter", IMPL_LOOKUP.findGetter(field.getType(), "nameToModule", Map.class));
                map.put("nameToModuleSetter", IMPL_LOOKUP.findSetter(field.getType(), "nameToModule", Map.class));
            }
            if (!map.isEmpty()) {
                return map;
            }
            return MixinConfigPlugin.findPackageLookup(cl.getSuperclass());
        }
        return null;
    }

    private static Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        try {
            MixinConfigPlugin.fixMixinModifyArgs();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

