/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fabric;

import com.google.common.collect.Lists;
import customskinloader.fabric.MixinConfigPlugin;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.game.patch.GameTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;

public class DevEnvRemapper
extends SimpleRemapper {
    private static Map<String, Map.Entry<List<String>, List<String>>> remappedClasses = new HashMap<String, Map.Entry<List<String>, List<String>>>();
    private final String owner;
    private final SimpleRemapper remapper = new SimpleRemapper(new HashMap()){

        public String map(String key) {
            return FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", Type.getType((String)("L" + key + ";")).getClassName()).replace(".", "/");
        }
    };

    public static void initRemapper() {
        try {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Field patchedClassesField = GameTransformer.class.getDeclaredField("patchedClasses");
                patchedClassesField.setAccessible(true);
                Map patchedClasses = (Map)patchedClassesField.get(FabricLoaderImpl.INSTANCE.getGameProvider().getEntrypointTransformer());
                for (Map.Entry<String, Map.Entry<List<String>, List<String>>> entry : remappedClasses.entrySet()) {
                    ArrayList targetClasses = new ArrayList(entry.getValue().getKey());
                    targetClasses.addAll(entry.getValue().getValue());
                    for (String clazz : targetClasses) {
                        byte[] classBytes = (byte[])patchedClasses.get(clazz);
                        if (classBytes == null) {
                            classBytes = IOUtils.toByteArray((InputStream)Objects.requireNonNull(cl.getResourceAsStream(clazz.replace(".", "/") + ".class")));
                        }
                        patchedClasses.put(clazz, DevEnvRemapper.remapClass(entry.getKey(), classBytes));
                    }
                }
            }
        }
        catch (Throwable t) {
            MixinConfigPlugin.logger.warning(t);
        }
    }

    public static byte[] remapClass(String owner, byte[] bytes) {
        ClassNode cn = new ClassNode();
        new ClassReader(bytes).accept((ClassVisitor)new ClassRemapper((ClassVisitor)cn, (Remapper)new DevEnvRemapper(owner)), 8);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public DevEnvRemapper(String owner) {
        super(new HashMap());
        this.owner = owner;
    }

    public String mapMethodName(String owner, String name, String desc) {
        desc = this.remapper.mapDesc(desc);
        String s = this.isFakeOwner(owner) ? FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", this.owner, name, desc) : name;
        return s == null ? name : s;
    }

    private boolean isFakeOwner(String owner) {
        return remappedClasses.get(this.owner).getKey().contains(owner.replace("/", "."));
    }

    static {
        remappedClasses.put("net.minecraft.class_310", new AbstractMap.SimpleEntry<ArrayList, ArrayList>(Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.IFakeMinecraft"}), Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.FakeInterfaceManager"})));
        remappedClasses.put("net.minecraft.class_1011", new AbstractMap.SimpleEntry<ArrayList, ArrayList>(Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.IFakeNativeImage"}), Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.FakeInterfaceManager"})));
        remappedClasses.put("net.minecraft.class_3298", new AbstractMap.SimpleEntry<ArrayList, ArrayList>(Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.IFakeIResource$V1", "customskinloader.fake.itf.IFakeIResource$V2"}), Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.FakeInterfaceManager"})));
        remappedClasses.put("net.minecraft.class_3300", new AbstractMap.SimpleEntry<ArrayList, ArrayList>(Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.IFakeIResourceManager"}), Lists.newArrayList((Object[])new String[]{"customskinloader.fake.itf.FakeInterfaceManager"})));
    }
}

