/*
 * Decompiled with CFR 0.152.
 */
package fliplus.spyglassastronomysync.client;

import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import java.util.ArrayList;
import java.util.Base64;

public class ClientSpaceDataManager {
    public static final int SAVE_FORMAT = 1;
    public static int revision;

    public static void loadData(String data) {
        SpaceDataManager spaceDataManager = SpyglassAstronomyClient.spaceDataManager;
        int stage = 0;
        Base64.Decoder decoder = Base64.getDecoder();
        int starIndex = 0;
        spaceDataManager.starDatas = new ArrayList();
        spaceDataManager.orbitingBodyDatas = new ArrayList();
        block7: for (String line : (String[])data.lines().toArray(String[]::new)) {
            if (line.equals("---")) {
                ++stage;
                continue;
            }
            switch (stage) {
                case 1: {
                    String[] seeds = line.split(" ");
                    if (seeds.length == 1) {
                        spaceDataManager.setStarSeed(Long.parseLong(line));
                        spaceDataManager.setPlanetSeed(spaceDataManager.getStarSeed());
                        continue block7;
                    }
                    spaceDataManager.setStarSeed(Long.parseLong(seeds[0]));
                    spaceDataManager.setPlanetSeed(Long.parseLong(seeds[1]));
                    continue block7;
                }
                case 2: {
                    String[] constellationParts = line.split(" \\| ");
                    SpyglassAstronomyClient.constellations.add(SpaceDataManager.decodeConstellation((Base64.Decoder)decoder, (String)constellationParts[0], (String)constellationParts[1]));
                    continue block7;
                }
                case 3: {
                    int starSplit = line.indexOf(32);
                    String starName = line.substring(starSplit + 1);
                    spaceDataManager.starDatas.add(new SpaceDataManager.StarData(starIndex += Integer.parseInt(line.substring(0, starSplit)), starName));
                    continue block7;
                }
                case 4: {
                    int orbitingBodySplit = line.indexOf(32);
                    int orbitingBodyIndex = Integer.parseInt(line.substring(0, orbitingBodySplit));
                    String orbitingBodyName = line.substring(orbitingBodySplit + 1);
                    spaceDataManager.orbitingBodyDatas.add(new SpaceDataManager.OrbitingBodyData(orbitingBodyIndex, orbitingBodyName));
                    continue block7;
                }
                case 5: {
                    String[] parts = line.split(" ");
                    SpyglassAstronomyClient.setStarCount((int)Integer.parseInt(parts[0]));
                    if (parts.length > 1) {
                        spaceDataManager.setYearLength(Float.parseFloat(parts[1]));
                        continue block7;
                    }
                    spaceDataManager.setYearLength(8.0f);
                }
            }
        }
    }

    public static String dataToString() {
        SpaceDataManager spaceDataManager = SpyglassAstronomyClient.spaceDataManager;
        StringBuilder s = new StringBuilder("Spyglass Astronomy - Format: 1");
        s.append("\n---\n");
        s.append(spaceDataManager.getStarSeed());
        if (spaceDataManager.getPlanetSeed() != spaceDataManager.getStarSeed()) {
            s.append(' ');
            s.append(spaceDataManager.getPlanetSeed());
        }
        s.append("\n---");
        Base64.Encoder encoder = Base64.getEncoder();
        for (Object constellation : SpyglassAstronomyClient.constellations) {
            s.append('\n');
            s.append(SpaceDataManager.encodeConstellation((Base64.Encoder)encoder, (Constellation)constellation));
        }
        s.append("\n---");
        int lastIndex = 0;
        for (Star star : SpyglassAstronomyClient.stars) {
            if (star.isUnnamed()) continue;
            s.append('\n');
            s.append(star.index - lastIndex).append(" ").append(star.name);
            lastIndex = star.index;
        }
        s.append("\n---");
        int index = 0;
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            if (!orbitingBody.isUnnamed()) {
                s.append('\n');
                s.append(index).append(" ").append(orbitingBody.name);
            }
            ++index;
        }
        s.append("\n---\n");
        s.append(SpyglassAstronomyClient.getStarCount());
        s.append(" ");
        s.append(spaceDataManager.getYearLength());
        s.append("\n---");
        return s.toString();
    }
}

