/*
 * Decompiled with CFR 0.152.
 */
package fliplus.spyglassastronomysync.client.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fliplus.spyglassastronomysync.SpyglassAstronomySync;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class SpyglassAstronomySyncConfig {
    public boolean AllowAdminCommands = false;
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("spyglass-astronomy-sync.json");
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).excludeFieldsWithModifiers(new int[]{16}).setPrettyPrinting().create();

    public static SpyglassAstronomySyncConfig loadConfig() {
        SpyglassAstronomySyncConfig spyglassAstronomySyncConfig;
        if (!Files.exists(configPath, new LinkOption[0])) {
            SpyglassAstronomySyncConfig.saveConfig(new SpyglassAstronomySyncConfig());
        }
        FileReader reader = new FileReader(configPath.toFile());
        try {
            SpyglassAstronomySyncConfig config = (SpyglassAstronomySyncConfig)GSON.fromJson((Reader)reader, SpyglassAstronomySyncConfig.class);
            if (config == null) {
                config = new SpyglassAstronomySyncConfig();
            }
            SpyglassAstronomySyncConfig.saveConfig(config);
            spyglassAstronomySyncConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SpyglassAstronomySync.LOGGER.error("Failed to load " + String.valueOf(configPath.getFileName()), (Throwable)e);
                SpyglassAstronomySync.LOGGER.error("Using default configuration instead");
                return new SpyglassAstronomySyncConfig();
            }
        }
        reader.close();
        return spyglassAstronomySyncConfig;
    }

    public static void saveConfig(SpyglassAstronomySyncConfig config) {
        try {
            Path configDirecotry = configPath.getParent();
            if (!Files.exists(configDirecotry, new LinkOption[0])) {
                Files.createDirectories(configDirecotry, new FileAttribute[0]);
            }
            Files.writeString(configPath, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write configuration file", e);
        }
    }
}

