/*
 * Decompiled with CFR 0.152.
 */
package fliplus.spyglassastronomysync.server.network;

import fliplus.spyglassastronomysync.SpyglassAstronomySync;
import fliplus.spyglassastronomysync.mixin.BiomeManagerAccessor;
import fliplus.spyglassastronomysync.network.AdminPrivilegesPacket;
import fliplus.spyglassastronomysync.network.DataPacket;
import fliplus.spyglassastronomysync.network.RequestDataPacket;
import fliplus.spyglassastronomysync.server.ServerSpaceDataManager;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ServerNetworking {
    public static void registerPayloads() {
        SpyglassAstronomySync.registerPayloads();
    }

    public static void sendData(class_3222 player, String data, int revision) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new DataPacket(data, revision));
    }

    public static void sendAdminPrivileges(class_3222 player, boolean allowAdminPrivileges) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new AdminPrivilegesPacket(allowAdminPrivileges));
    }

    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(DataPacket.TYPE, ServerNetworking::handleData);
        ServerPlayNetworking.registerGlobalReceiver(RequestDataPacket.TYPE, ServerNetworking::handleDataRequest);
    }

    private static void handleData(DataPacket packet, ServerPlayNetworking.Context context) {
        String data = packet.data();
        int revision = packet.revision();
        long seedHash = ((BiomeManagerAccessor)context.player().method_51469().method_22385()).getBiomeZoomSeed();
        boolean isDesynced = ServerSpaceDataManager.isDesynced(revision);
        if (isDesynced) {
            String storedData = ServerSpaceDataManager.getData(context.server(), seedHash);
            context.player().method_64398((class_2561)class_2561.method_43470((String)"You were desynced from the server. Please make your change again").method_27692(class_124.field_1061));
            ServerNetworking.sendData(context.player(), storedData, ServerSpaceDataManager.revision);
            return;
        }
        ServerSpaceDataManager.saveData(data, context.server(), seedHash);
        for (class_3222 player : context.server().method_3760().method_14571()) {
            if (player == context.player()) continue;
            ServerNetworking.sendData(player, data, revision);
        }
    }

    private static void handleDataRequest(RequestDataPacket packet, ServerPlayNetworking.Context context) {
        long seedHash = ((BiomeManagerAccessor)context.player().method_51469().method_22385()).getBiomeZoomSeed();
        String storedData = ServerSpaceDataManager.getData(context.server(), seedHash);
        ServerNetworking.sendData(context.player(), storedData, ServerSpaceDataManager.revision);
    }
}

