package cz.yorick.api.registry;

import com.mojang.serialization.Codec;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.resources.SimpleResources;
import java.util.Map;
import net.minecraft.class_2960;

/**
 * Disables registering values manually, but allows
 * reloading the registry with a map of new values
 * */
public class SimpleDynamicRegistry<K, V> extends SimpleRegistry<K, V> {
    public SimpleDynamicRegistry(class_2960 registryId, Codec<K> keyCodec) {
        super(registryId, keyCodec);
    }

    public void reload(Map<K, V> newValues) {
        this.registry.clear();
        this.keyRegistry.clear();
        newValues.forEach(super::register);
        SimpleResourcesCommon.LOGGER.info("Reloaded the registry " + getRegistryId());
    }

    @Override
    public void register(K key, V value) {
        throw new UnsupportedOperationException("Cannot call .register() on a dynamic registry! Values can only be modified when reloading with the .reload() method!");
    }

    /**
     * Creates a data pack resource and wraps it in a dynamic registry.
     * Any time the resource gets reloaded, the registries values get updated
     * */
    public static <T> SimpleDynamicRegistry<class_2960, T> ofDatapackResource(class_2960 id, Codec<T> codec) {
        SimpleDynamicRegistry<class_2960, T> dynamicRegistry = new SimpleDynamicRegistry<>(id, class_2960.field_25139);
        SimpleResources.datapackResource(id, codec, dynamicRegistry::reload);
        return dynamicRegistry;
    }

    /**
     * Creates a resource pack resource and wraps it in a dynamic registry.
     * Any time the resource gets reloaded, the registries values get updated
     * */
    public static <T> SimpleDynamicRegistry<class_2960, T> ofResourcepackResource(class_2960 id, Codec<T> codec) {
        SimpleDynamicRegistry<class_2960, T> dynamicRegistry = new SimpleDynamicRegistry<>(id, class_2960.field_25139);
        SimpleResources.resourcepackResource(id, codec, dynamicRegistry::reload);
        return dynamicRegistry;
    }
}
