package cz.yorick.api.resources;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import cz.yorick.command.CommandUtil;
import cz.yorick.resources.Util;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_8935;

public interface ResourceUtil {
    /**
     * Gets the file extension from the path of the identifier
     * */
    static String getFileExtension(class_2960 id) {
        return getFileExtension(id.method_12832());
    }

    /**
     * Gets the file extension of a path, expected file separator is "/"
     * */
    static String getFileExtension(String path) {
        return Util.getFileExtension(path);
    }

    /**
     * Removes the file extension from the path of the identifier
     * */
    static class_2960 removeFileExtension(class_2960 id) {
        return id.method_45136(removeFileExtension(id.method_12832()));
    }

    /**
     * Removes file extension from a path, expected file separator is "/"
     * */
    static String removeFileExtension(String path) {
        return Util.removeFileExtension(path);
    }

    /**
     * Suggests matching from the list
     * @param options The possible options for this argument
     * @param builder The builder provided by {@link com.mojang.brigadier.builder.RequiredArgumentBuilder#suggests(SuggestionProvider)}
     * @return The possible options based on the inputted text
     * */
    static CompletableFuture<Suggestions> suggestMatching(Collection<String> options, SuggestionsBuilder builder) {
        return CommandUtil.suggestMatching(options, builder);
    }

    /**
     * Executes a function - adds withLevel(2) and withSilent()
     * @param source Source to execute as
     * @param functionId Id of the function
     * @return true if the function was executed, false otherwise
     * */
    static boolean executeFunction(class_2168 source, class_2960 functionId) {
        return executeFunction(source, functionId, class_8935.field_47158);
    }

    /**
     * Executes a function - adds withLevel(2) and withSilent()
     * @param source Source to execute as
     * @param functionId Id of the function
     * @param returnValueConsumer Consumer for the return value of the function
     * @return true if the function was executed, false otherwise
     * */
    static boolean executeFunction(class_2168 source, class_2960 functionId, class_8935 returnValueConsumer) {
        return executeRawFunction(source.method_9206(2).method_9217().method_9209(returnValueConsumer, class_8935::chain), functionId);
    }

    /**
     * Executes a function
     * @param source Source to execute as
     * @param functionId Id of the function
     * @return true if the function was executed, false otherwise
     * */
    static boolean executeRawFunction(class_2168 source, class_2960 functionId) {
        return executeRawMacroFunction(source, functionId, null);
    }

    /**
     * Executes a macro function - adds withLevel(2) and withSilent()
     * @param source Source to execute as
     * @param functionId Id of the function
     * @param data The data to execute the function with
     * @return true if the function was executed, false otherwise
     * */
    static boolean executeMacroFunction(class_2168 source, class_2960 functionId, class_2487 data) {
        return executeMacroFunction(source, functionId, data, class_8935.field_47158);
    }

    /**
     * Executes a macro function - adds withLevel(2) and withSilent()
     * @param source Source to execute as
     * @param functionId Id of the function
     * @param data The data to execute the function with
     * @param returnValueConsumer Consumer for the return value of the function
     * @return true if the function was executed, false otherwise
     * */
    static boolean executeMacroFunction(class_2168 source, class_2960 functionId, class_2487 data, class_8935 returnValueConsumer) {
        return executeRawMacroFunction(source.method_9206(2).method_9217().method_9209(returnValueConsumer, class_8935::chain), functionId, data);
    }

    /**
     * Executes a macro function
     * @param source Source to execute as
     * @param functionId Id of the function
     * @param data The data to execute the function with
     * @return true if the function was executed, false otherwise
     * */
    static boolean executeRawMacroFunction(class_2168 source, class_2960 functionId, class_2487 data) {
        return CommandUtil.executeMacroFunction(source, functionId, data);
    }

    /**
     * Executes a command - adds withLevel(2) and withSilent()
     * @param source Source to execute as
     * @param command The command
     * */
    static void executeCommand(class_2168 source, String command) {
        executeCommand(source, command, class_8935.field_47158);
    }

    /**
     * Executes a command - adds withLevel(2) and withSilent()
     * @param source Source to execute as
     * @param command The command
     * @param returnValueConsumer Consumer for the return value of the function
     * */
    static void executeCommand(class_2168 source, String command, class_8935 returnValueConsumer) {
        executeRawCommand(source.method_9206(2).method_9217().method_9209(returnValueConsumer, class_8935::chain), command);
    }

    /**
     * Executes a command
     * @param source Source to execute as
     * @param command The command
     * */
    static void executeRawCommand(class_2168 source, String command) {
        source.method_9211().method_3734().method_44252(source, command);
    }
}
