package cz.yorick.command;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import cz.yorick.SimpleResourcesCommon;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8854;
import net.minecraft.class_8868;
import net.minecraft.class_8935;

public class CommandUtil {
    public static CompletableFuture<Suggestions> suggestMatching(Collection<String> options, SuggestionsBuilder builder) {
        String input = builder.getInput();
        if(input.endsWith(" ")) {
            options.forEach(builder::suggest);
            return builder.buildFuture();
        }

        String[] splitInput = input.split(" ");
        String typing = splitInput[splitInput.length - 1];
        options.stream().filter(key -> key.startsWith(typing)).forEach(builder::suggest);
        return builder.buildFuture();
    }

    public static boolean executeMacroFunction(class_2168 source, class_2960 functionId, class_2487 data) {
        Optional<class_2158<class_2168>> function = source.method_9211().method_3740().method_12905(functionId);
        return function.isEmpty() ? false : executeMacroFunction(source, function.get(), data);
    }

    public static boolean executeMacroFunction(class_2168 source, class_2158<class_2168> function, class_2487 data) {
        try {
            class_8868<class_2168> procedure = function.method_52595(data, source.method_54310());
            class_2170.method_54313(source, (context) -> class_8854.method_54395(context, procedure, source, class_8935.field_47158));
            return true;
        } catch (Exception e) {
            source.method_9213(class_2561.method_43470("Something went wrong trying to execute that..."));
            SimpleResourcesCommon.LOGGER.warn("Failed to execute function '" + function.comp_1994() + "' with data " + data, e);
            return false;
        }
    }
}
