package cz.yorick.resources.type;

import com.google.common.collect.ImmutableMap;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.resources.ResourceKey;
import cz.yorick.api.resources.ResourceReadWriter;
import cz.yorick.api.resources.ResourceUtil;
import cz.yorick.resources.Util;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class MinecraftResource<T> implements ResourceKey<Map<class_2960, T>> {
    private final Consumer<Map<class_2960, T>> reloadListener;
    private Map<class_2960, T> loadedValue = ImmutableMap.of();
    public MinecraftResource(class_2960 id, ResourceReadWriter<T> readWriter, class_3264 resourceType, Consumer<Map<class_2960, T>> reloadListener) {
        this.reloadListener = reloadListener;
        ResourceManagerHelper.get(resourceType).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return id;
            }

            @Override
            public void method_14491(class_3300 manager) {
                parse(id.method_12832(), manager, readWriter);
            }
        });
    }

    @Override
    public Map<class_2960, T> getValue() {
        return this.loadedValue;
    }

    private void parse(String resourceName, class_3300 resourceManager, ResourceReadWriter<T> readWriter) {
        HashMap<class_2960, T> results = new HashMap<>();
        for(Map.Entry<class_2960, class_3298> entry : resourceManager.method_14488(resourceName, identifier -> true).entrySet()) {
            try {
                class_2960 originalKey = entry.getKey();
                String fileExtension = Util.getFileExtensionOrThrow(originalKey.method_12832());
                T parsed = readWriter.read(fileExtension, entry.getValue().method_43039());
                //converts
                //namespace:resource_name/file_name.extension -> namespace:file_name.extension
                //namespace:resource_name/directory/file_name.extension -> namespace:directory/file_name.extension
                class_2960 loadedKey = originalKey.method_45136(originalKey.method_12832().substring(resourceName.length() + 1));
                if(readWriter.shouldStripFileExtension(fileExtension)) {
                    loadedKey = ResourceUtil.removeFileExtension(loadedKey);
                }

                if (results.containsKey(loadedKey)) {
                    throw new IllegalStateException("Duplicate data file ignored with ID " + loadedKey + " (path " + originalKey + ")");
                }

                results.put(loadedKey, parsed);
            } catch (Exception e) {
                SimpleResourcesCommon.LOGGER.error("Error occurred while loading resource: " + entry.getKey().toString(), e);
            }
        }

        this.loadedValue = ImmutableMap.copyOf(results);
        this.reloadListener.accept(this.loadedValue);
    }
}
