package cz.yorick.resources.type;

import cz.yorick.api.resources.ReloadableResourceKey;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public class SimpleReloadableResource<T> extends SimpleResource<T> implements ReloadableResourceKey<T> {
    private final Consumer<T> reloadListener;
    public SimpleReloadableResource(class_2960 configId, Loader<T> loader, Consumer<T> reloadListener) {
        super(configId, loader);
        this.reloadListener = reloadListener;
        //supers constructor loads the value
        this.reloadListener.accept(this.getLoadedValue());
    }

    @Override
    public void reload(Consumer<Exception> errorHandler) {
        this.load(errorHandler::accept);
        this.reloadListener.accept(this.getLoadedValue());
    }

    @Override
    public T getValue() {
        return this.getLoadedValue();
    }
}
