package cz.yorick.resources.type;

import cz.yorick.SimpleResourcesCommon;
import cz.yorick.resources.ResourceParseException;
import cz.yorick.resources.Util;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import java.nio.file.Path;
import java.util.function.Consumer;

public class SimpleResource<T> {
    private final Path path;
    private final Loader<T> loader;
    private T loadedValue;
    public SimpleResource(class_2960 configId, Loader<T> loader) {
        class_2960 validatedId = loader.getValidatedId(configId);
        this.path = FabricLoader.getInstance().getConfigDir().resolve(toPath(validatedId));
        this.loader = loader;
        Util.registerConfig(validatedId, this);
        this.load(error -> SimpleResourcesCommon.LOGGER.error("Error while loading the resource " + validatedId, error));
    }

    public T getLoadedValue() {
        return this.loadedValue;
    }

    protected void load(Consumer<ResourceParseException> errorHandler) {
        this.loadedValue = this.loader.load(this.path, errorHandler);
    }

    private static Path toPath(class_2960 id) {
        Path filePath = Path.of(id.method_12836());
        String[] path = id.method_12832().split("/");
        for (String pathPart : path) {
            filePath = filePath.resolve(pathPart);
        }

        return filePath;
    }

    public interface Loader<T> {
        T load(Path path, Consumer<ResourceParseException> errorHandler);
        class_2960 getValidatedId(class_2960 id);
        static Path getRelativePath(Path fullPath) {
            return FabricLoader.getInstance().getConfigDir().relativize(fullPath);
        }
    }
}
