/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.api.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import cz.yorick.codec.DelegatedDispatchedMapCodec;
import cz.yorick.codec.EnumCodec;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface CodecUtils {
    public static <T extends Enum<T>> Codec<T> enumCodec(Class<T> enumClass) {
        return EnumCodec.of(enumClass);
    }

    public static <T extends Enum<T>> Codec<T> caseConvertingEnum(Class<T> enumClass) {
        return EnumCodec.caseConverting(enumClass);
    }

    public static <K, V> MapCodec<Map<K, V>> unboundedMap(Set<String> keys, Codec<K> keyCodec, Codec<V> valueCodec) {
        return CodecUtils.dispatchedMap(keys, keyCodec, key -> valueCodec);
    }

    public static <K, V> MapCodec<Map<K, V>> dispatchedMap(Set<String> keys, Codec<K> keyCodec, Function<K, Codec<? extends V>> keyToCodec) {
        return new DelegatedDispatchedMapCodec<K, V>(keys, keyCodec, keyToCodec);
    }
}

