/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.api.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2960;

public class SimpleRegistry<K, V> {
    protected final HashMap<K, V> registry = new HashMap();
    protected final HashMap<V, K> keyRegistry = new HashMap();
    private final class_2960 registryId;
    private final Codec<V> codec;

    public SimpleRegistry(class_2960 registryId, Codec<K> keyCodec) {
        this.registryId = registryId;
        this.codec = keyCodec.flatXmap(key -> {
            V value = this.getOrNull(key);
            if (value != null) {
                return DataResult.success(value);
            }
            return DataResult.error(() -> "Invalid key for registry " + String.valueOf(this.registryId) + " '" + String.valueOf(key) + "'");
        }, value -> {
            K key = this.getIdOrNull(value);
            if (key != null) {
                return DataResult.success(key);
            }
            return DataResult.error(() -> "Invalid value for registry " + String.valueOf(this.registryId) + " '" + String.valueOf(value) + "'");
        });
    }

    public List<K> getKeys() {
        return List.copyOf(this.registry.keySet());
    }

    public List<V> getValues() {
        return List.copyOf(this.keyRegistry.keySet());
    }

    public class_2960 getRegistryId() {
        return this.registryId;
    }

    public V getOrNull(K key) {
        return this.registry.get(key);
    }

    public K getIdOrNull(V value) {
        return this.keyRegistry.get(value);
    }

    public void register(K key, V value) {
        if (this.registry.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate id in registry " + String.valueOf(this.registryId) + " '" + String.valueOf(key) + "'");
        }
        if (this.keyRegistry.containsKey(value)) {
            throw new IllegalArgumentException("Duplicate value in registry " + String.valueOf(this.registryId) + " '" + String.valueOf(value) + "'");
        }
        this.registry.put(key, value);
        this.keyRegistry.put(value, key);
    }

    public Codec<V> getCodec() {
        return this.codec;
    }
}

