/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class DelegatedDispatchedMapCodec<K, V>
extends MapCodec<Map<K, V>> {
    private final Set<String> keys;
    private final Codec<Map<K, V>> codec;

    public DelegatedDispatchedMapCodec(Set<String> keys, Codec<K> keyCodec, Function<K, Codec<? extends V>> keyToCodec) {
        this.keys = keys;
        this.codec = Codec.dispatchedMap(keyCodec, keyToCodec);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return this.keys.stream().map(arg_0 -> ops.createString(arg_0));
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        List validKeys = this.keys(ops).toList();
        Object normalInput = ops.createMap(input.entries().filter(pair -> validKeys.contains(pair.getFirst())));
        return this.codec.parse(ops, normalInput);
    }

    public <T> RecordBuilder<T> encode(Map<K, V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        DataResult result = this.codec.encodeStart(ops, input);
        if (result.isError()) {
            prefix.withErrorsFrom(result);
            return prefix;
        }
        DataResult mapLike = ops.getMap(result.getOrThrow());
        if (mapLike.isError()) {
            prefix.withErrorsFrom(mapLike);
            return prefix;
        }
        ((MapLike)mapLike.getOrThrow()).entries().forEach(pair -> prefix.add(pair.getFirst(), pair.getSecond()));
        return prefix;
    }
}

