/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.codec.reflection;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.codec.annotations.FieldId;
import cz.yorick.api.codec.annotations.OptionalField;
import cz.yorick.codec.DelegatedDispatchedMapCodec;
import cz.yorick.codec.EnumCodec;
import cz.yorick.codec.reflection.ClassFieldsReflectionCodec;
import cz.yorick.codec.reflection.RecordFieldsReflectionCodec;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public abstract class FieldsReflectionCodec<C, T extends C> {
    public static final ImmutableMap<Class<?>, Codec<?>> DEFAULT_CODECS = ImmutableMap.builder().put(Boolean.TYPE, (Object)Codec.BOOL).put(Boolean.class, (Object)Codec.BOOL).put(Byte.TYPE, (Object)Codec.BYTE).put(Byte.class, (Object)Codec.BYTE).put(Integer.TYPE, (Object)Codec.INT).put(Integer.class, (Object)Codec.INT).put(Float.TYPE, (Object)Codec.FLOAT).put(Float.class, (Object)Codec.FLOAT).put(Double.TYPE, (Object)Codec.DOUBLE).put(Double.class, (Object)Codec.DOUBLE).put(Long.TYPE, (Object)Codec.LONG).put(Long.class, (Object)Codec.LONG).put(String.class, (Object)Codec.STRING).put(class_1792.class, (Object)class_7923.field_41178.method_39673()).put(class_1299.class, (Object)class_7923.field_41177.method_39673()).put(class_2248.class, (Object)class_7923.field_41175.method_39673()).put(class_2960.class, (Object)class_2960.field_25139).put(class_1799.class, (Object)class_1799.field_24671).build();
    protected final Supplier<T> defaultFactory;
    protected final Map<Class<?>, Codec<?>> extraCodecs;
    protected final Map<String, Codec<?>> codecOverwrites;
    protected final Function<T, DataResult<T>> postProcessor;
    protected final LinkedHashMap<String, SerializableField> classFields;

    FieldsReflectionCodec(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        this.defaultFactory = defaultFactory;
        this.extraCodecs = ImmutableMap.copyOf(extraCodecs);
        this.codecOverwrites = ImmutableMap.copyOf(codecOverwrites);
        this.postProcessor = postProcessor;
        this.classFields = this.getClassFields(clazz, convertNames);
    }

    public static String convertName(String name) {
        StringBuilder builder = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                builder.append("_");
                builder.append(Character.toLowerCase(ch));
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    protected DataResult<Map<String, Object>> getValues(T instance) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, SerializableField> entry : this.classFields.entrySet()) {
            DataResult<Object> value = entry.getValue().get(instance);
            if (value.isError()) {
                return DataResult.error(() -> "Cannot serialize the field '" + (String)entry.getKey() + "' - check the log for details");
            }
            if (value.getOrThrow() == null) continue;
            values.put(entry.getKey(), value.getOrThrow());
        }
        return DataResult.success(values);
    }

    protected Pair<String, SerializableField> getFieldEntry(Field field, boolean convertNames) {
        String fieldId = this.getFieldId(field, convertNames);
        boolean required = field.getAnnotation(OptionalField.class) == null;
        Codec<?> overwriteCodec = this.codecOverwrites.get(fieldId);
        if (overwriteCodec != null) {
            return Pair.of((Object)fieldId, (Object)new SerializableField(field, overwriteCodec, required));
        }
        Class<?> fieldClass = field.getType();
        Codec<?> codec = this.extraCodecs.get(fieldClass);
        if (codec != null) {
            return Pair.of((Object)fieldId, (Object)new SerializableField(field, codec, required));
        }
        Codec defaultCodec = (Codec)DEFAULT_CODECS.get(fieldClass);
        if (defaultCodec != null) {
            return Pair.of((Object)fieldId, (Object)new SerializableField(field, defaultCodec, required));
        }
        if (fieldClass.isEnum()) {
            return Pair.of((Object)fieldId, (Object)new SerializableField(field, EnumCodec.of(fieldClass.asSubclass(Enum.class)), required));
        }
        throw new IllegalArgumentException("Could not get codec for field '" + field.getName() + "' no codec registered for class " + fieldClass.getName() + " or field id '" + fieldId + "'");
    }

    private String getFieldId(Field field, boolean convertNames) {
        FieldId fieldId = field.getAnnotation(FieldId.class);
        if (fieldId == null) {
            return convertNames ? FieldsReflectionCodec.convertName(field.getName()) : field.getName();
        }
        if (fieldId.id().isEmpty()) {
            throw new IllegalArgumentException("Field '" + field.getName() + "' is marked with @FieldId(id = \"\"), the name of the field cannot be empty!");
        }
        return fieldId.id();
    }

    protected Codec<?> getFieldCodec(String fieldName) {
        SerializableField field = this.classFields.get(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Attempted to get a codec for an unknown field '" + fieldName + "' - this should be filtered out by DelegatedDispatchedMapCodec and never happen!");
        }
        return field.codec();
    }

    protected abstract LinkedHashMap<String, SerializableField> getClassFields(Class<C> var1, boolean var2);

    protected abstract DataResult<T> createWithValues(Map<String, Object> var1);

    public static <C, T extends C> Codec<T> of(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        return FieldsReflectionCodec.ofMap(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames).codec();
    }

    public static <C, T extends C> MapCodec<T> ofMap(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        FieldsReflectionCodec<C, T> reflectionCodec = FieldsReflectionCodec.createFor(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames);
        DelegatedDispatchedMapCodec objects = new DelegatedDispatchedMapCodec(reflectionCodec.classFields.keySet(), class_5699.field_41759, reflectionCodec::getFieldCodec);
        return objects.flatXmap(reflectionCodec::createWithValues, reflectionCodec::getValues);
    }

    private static <C, T extends C> FieldsReflectionCodec<C, T> createFor(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        if (clazz.isRecord()) {
            return new RecordFieldsReflectionCodec<C, T>(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames);
        }
        return new ClassFieldsReflectionCodec<C, T>(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames);
    }

    protected record SerializableField(Field field, Codec<?> codec, boolean required) {
        protected DataResult<Object> get(Object instance) {
            try {
                return DataResult.success((Object)this.field.get(instance));
            }
            catch (IllegalAccessException e) {
                SimpleResourcesCommon.LOGGER.error("Could not retrieve the value of config field '" + this.field.getName() + "'", (Throwable)e);
                return DataResult.error(() -> "Could not retrieve the value of config field '" + this.field.getName() + "' - Check the log for more details");
            }
        }

        protected void set(Object instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (Exception e) {
                SimpleResourcesCommon.LOGGER.error("Could not assign value to the config field '" + this.field.getName() + "'", (Throwable)e);
            }
        }
    }
}

