/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.codec.reflection;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.codec.annotations.Ignore;
import cz.yorick.api.codec.annotations.OptionalField;
import cz.yorick.codec.DelegatedDispatchedMapCodec;
import cz.yorick.codec.reflection.ClassFieldsReflectionCodec;
import cz.yorick.codec.reflection.FieldsReflectionCodec;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_5699;

public class RecordFieldsReflectionCodec<C, T extends C>
extends FieldsReflectionCodec<C, T> {
    private final Constructor<T> canonicalConstructor;

    RecordFieldsReflectionCodec(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        super(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames);
        this.canonicalConstructor = this.getCanonicalConstructor(clazz);
    }

    private Constructor<T> getCanonicalConstructor(Class<C> recordClass) {
        if (this.defaultFactory != null && recordClass != this.defaultFactory.get().getClass()) {
            throw new IllegalArgumentException("For record reflection codecs the specified class and the class returned by the default constructor must be the same!");
        }
        try {
            return recordClass.getConstructor((Class[])Arrays.stream(recordClass.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new));
        }
        catch (Exception e) {
            throw new IllegalStateException("Record class is missing a canonical constructor (how?)", e);
        }
    }

    @Override
    protected LinkedHashMap<String, FieldsReflectionCodec.SerializableField> getClassFields(Class<C> clazz, boolean convertNames) {
        RecordComponent[] recordComponents;
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("RecordFieldsReflectionCodec only accepts records, use RecordFieldsReflectionCodec instead (should be handled automatically if you are an api user)");
        }
        LinkedHashMap<String, FieldsReflectionCodec.SerializableField> classFields = new LinkedHashMap<String, FieldsReflectionCodec.SerializableField>();
        for (RecordComponent recordComponent : recordComponents = clazz.getRecordComponents()) {
            OptionalField optionalField;
            Field field = this.getRecordField(clazz, recordComponent);
            Ignore ignore = field.getAnnotation(Ignore.class);
            if (ignore != null) {
                SimpleResourcesCommon.LOGGER.warn("@Ignore annotation present in a RecordFieldsReflectionCodec for class '" + clazz.getName() + "' on field '" + field.getName() + "', the annotation will have no effect!");
            }
            if ((optionalField = field.getAnnotation(OptionalField.class)) != null && this.defaultFactory == null) {
                throw new IllegalStateException("@OptionalField annotation found in a RecordFieldsReflectionCodec on field '" + recordComponent.getName() + "', but this codec is missing a default constructor!");
            }
            Pair<String, FieldsReflectionCodec.SerializableField> recordEntry = this.getFieldEntry(field, convertNames);
            classFields.put((String)recordEntry.getFirst(), (FieldsReflectionCodec.SerializableField)recordEntry.getSecond());
        }
        return classFields;
    }

    private Field getRecordField(Class<C> recordClass, RecordComponent component) {
        try {
            Field field = recordClass.getDeclaredField(component.getName());
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new IllegalStateException("Record class is missing a field but has a component with name: " + component.getName() + " (how?)");
        }
    }

    @Override
    public DataResult<T> createWithValues(Map<String, Object> values) {
        Object[] constructorParams = new Object[this.canonicalConstructor.getParameterCount()];
        Object defaultInstance = null;
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        int i = 0;
        for (Map.Entry entry : this.classFields.entrySet()) {
            Object value = values.get(entry.getKey());
            if (value == null) {
                if (((FieldsReflectionCodec.SerializableField)entry.getValue()).required()) {
                    if (defaultInstance == null && this.defaultFactory != null) {
                        defaultInstance = this.defaultFactory.get();
                    }
                    if (defaultInstance == null) {
                        return DataResult.error(() -> "Missing a required key: '" + (String)entry.getKey() + "'");
                    }
                    errors.add((CallSite)((Object)("Missing a required key: '" + (String)entry.getKey() + "'")));
                }
                if (defaultInstance == null) {
                    defaultInstance = this.defaultFactory.get();
                }
                constructorParams[i] = ((FieldsReflectionCodec.SerializableField)entry.getValue()).get(defaultInstance);
            }
            constructorParams[i] = value;
            ++i;
        }
        try {
            T result = this.canonicalConstructor.newInstance(constructorParams);
            this.postProcessor.apply(result);
            if (!errors.isEmpty()) {
                return DataResult.error(() -> String.join((CharSequence)" | ", errors), result);
            }
            return (DataResult)this.postProcessor.apply(result);
        }
        catch (Exception e) {
            SimpleResourcesCommon.LOGGER.error("Could not run the constructor: ", (Throwable)e);
            return DataResult.error(() -> "Could not run the constructor - check the log for details");
        }
    }

    public static <C, T extends C> Codec<T> of(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        return RecordFieldsReflectionCodec.ofMap(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames).codec();
    }

    public static <C, T extends C> MapCodec<T> ofMap(Class<C> clazz, Supplier<T> defaultFactory, Map<Class<?>, Codec<?>> extraCodecs, Map<String, Codec<?>> codecOverwrites, Function<T, DataResult<T>> postProcessor, boolean convertNames) {
        ClassFieldsReflectionCodec<C, T> fieldsCodec = new ClassFieldsReflectionCodec<C, T>(clazz, defaultFactory, extraCodecs, codecOverwrites, postProcessor, convertNames);
        DelegatedDispatchedMapCodec objects = new DelegatedDispatchedMapCodec(fieldsCodec.classFields.keySet(), class_5699.field_41759, fieldsCodec::getFieldCodec);
        return objects.flatXmap(fieldsCodec::createWithValues, fieldsCodec::getValues);
    }
}

