/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import cz.yorick.api.resources.ResourceReadWriter;
import cz.yorick.command.CommandUtil;
import cz.yorick.resources.ErrorUtil;
import cz.yorick.resources.ResourceParseException;
import cz.yorick.resources.Util;
import cz.yorick.resources.loader.CodecResourceReadWriter;
import cz.yorick.resources.type.SimpleReloadableResource;
import cz.yorick.resources.type.SimpleResource;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class SimpleResourcesCommand<S extends class_2172> {
    private final BiConsumer<S, class_2561> feedbackSender;

    protected SimpleResourcesCommand(CommandDispatcher<S> dispatcher, String commandName, BiConsumer<S, class_2561> feedbackSender, Predicate<S> canExecute) {
        this.feedbackSender = feedbackSender;
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal(commandName).requires(canExecute)).then(((LiteralArgumentBuilder)this.literal("reload").executes(context -> this.executeReloadAll((class_2172)context.getSource()))).then(this.argument("config", (ArgumentType)class_2232.method_9441()).suggests(this::suggestReloadableConfigResources).executes(context -> this.executeReload((class_2172)context.getSource(), (class_2960)context.getArgument("config", class_2960.class)))))).then(this.literal("convert").then(this.argument("format", (ArgumentType)StringArgumentType.string()).suggests(this::suggestFormat).then(((RequiredArgumentBuilder)this.argument("id", (ArgumentType)class_2232.method_9441()).suggests(this::suggestConfigResources).executes(context -> this.convertConfig((class_2172)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"format"), (class_2960)context.getArgument("id", class_2960.class), null))).then(this.argument("path", (ArgumentType)StringArgumentType.string()).executes(context -> this.convertConfig((class_2172)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"format"), (class_2960)context.getArgument("id", class_2960.class), StringArgumentType.getString((CommandContext)context, (String)"path")))))))).then(this.literal("repair").then(this.argument("config", (ArgumentType)class_2232.method_9441()).suggests(this::suggestConfigResources).executes(context -> this.repairConfig((class_2172)context.getSource(), (class_2960)context.getArgument("config", class_2960.class))))));
    }

    private LiteralArgumentBuilder<S> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private <T> RequiredArgumentBuilder<S, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    private CompletableFuture<Suggestions> suggestReloadableConfigResources(CommandContext<S> context, SuggestionsBuilder builder) {
        return CommandUtil.suggestMatching(Util.getReloadableResourceKeys().stream().map(class_2960::toString).toList(), builder);
    }

    private CompletableFuture<Suggestions> suggestConfigResources(CommandContext<S> context, SuggestionsBuilder builder) {
        return CommandUtil.suggestMatching(Util.getResourceKeys().stream().map(class_2960::toString).toList(), builder);
    }

    private CompletableFuture<Suggestions> suggestFormat(CommandContext<S> context, SuggestionsBuilder builder) {
        return CommandUtil.suggestMatching(CodecResourceReadWriter.getRegisteredExtensions(), builder);
    }

    private int executeReloadAll(S source) {
        Util.getReloadableResources().forEach(reloadableConfig -> reloadableConfig.reload(error -> this.handleError(source, (Exception)error)));
        this.sendSuccess(source, "Reloaded config resources");
        return 1;
    }

    private int executeReload(S source, class_2960 id) {
        SimpleReloadableResource<?> config = Util.getReloadableResource(id);
        if (config == null) {
            this.sendError(source, "Config resource " + String.valueOf(id) + " does not exist or is unreloadable");
            return 0;
        }
        config.reload(error -> this.handleError(source, (Exception)error));
        this.sendSuccess(source, "Reloaded the config resource " + String.valueOf(id));
        return 1;
    }

    protected int convertConfig(S source, String format, class_2960 id, String path) {
        SimpleResource<?> config = Util.getResource(id);
        if (config == null) {
            this.sendError(source, "Config resource " + String.valueOf(id) + " does not exist");
            return 0;
        }
        ResourceReadWriter<?> readWriter = config.getReadWriter();
        if (readWriter instanceof CodecResourceReadWriter) {
            return this.convertPath(source, format, config.getFile().toPath(), path);
        }
        this.sendError(source, "Config resource " + String.valueOf(id) + " is not a codec resource and cannot be converted");
        return 0;
    }

    protected int convertPath(S source, String format, Path startPath, String path) {
        File file;
        CodecResourceReadWriter.DynamicOpsParser<?> requiredParser = CodecResourceReadWriter.getParser(format);
        if (requiredParser == null) {
            this.sendError(source, "No parser registered for format " + format);
            return 0;
        }
        if (path != null) {
            for (String pathPart : path.split("/")) {
                startPath = startPath.resolve(pathPart);
            }
        }
        if (!(file = startPath.toFile()).exists()) {
            this.sendError(source, "The specified file does not exist");
            return 0;
        }
        return this.convert(source, file, format, requiredParser);
    }

    private int convert(final S source, File original, final String requiredExtension, final CodecResourceReadWriter.DynamicOpsParser<?> requiredFormatParser) {
        final AtomicInteger total = new AtomicInteger(0);
        final AtomicInteger success = new AtomicInteger(0);
        if (original.isDirectory()) {
            try {
                Files.walkFileTree(original.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        total.addAndGet(1);
                        File original = file.toFile();
                        success.addAndGet(SimpleResourcesCommand.this.convertFile(source, original, SimpleResourcesCommand.this.getFile(original, requiredExtension), requiredFormatParser));
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                ErrorUtil.sendStackTrace(new ResourceParseException("Fatal error while converting the resource", e), message -> this.sendError(source, (String)message));
            }
            this.sendSuccess(source, "Converted " + success.get() + "/" + total.get() + " files");
            return success.get();
        }
        if (original.isFile()) {
            return this.convertFile(source, original, this.getFile(original, requiredExtension), requiredFormatParser);
        }
        this.sendError(source, "File is not a directory or a file");
        return 0;
    }

    private File getFile(File original, String requiredExtension) {
        return new File(original.getParent(), Util.removeFileExtension(original.getName()) + "." + requiredExtension);
    }

    private int convertFile(S source, File original, File destination, CodecResourceReadWriter.DynamicOpsParser<?> requiredFormatParser) {
        try {
            if (original.equals(destination)) {
                this.sendSuccess(source, "File " + original.getName() + " is already in the requested format");
                return 1;
            }
            if (!destination.exists() && !destination.createNewFile()) {
                this.sendError(source, "Failed to create file" + original.getName());
                return 0;
            }
            String originalExtension = Util.getFileExtension(original.getName());
            CodecResourceReadWriter.DynamicOpsParser<?> originalParser = CodecResourceReadWriter.getParser(originalExtension);
            if (originalParser == null) {
                this.sendError(source, "Cannot convert the file " + original.getName() + " since no parser is registered for extension " + originalExtension);
                return 0;
            }
            FileReader reader = new FileReader(original);
            FileWriter writer = new FileWriter(destination);
            originalParser.convertTo(requiredFormatParser, reader, writer);
            reader.close();
            writer.close();
            this.sendSuccess(source, "File " + original.getName() + " converted to " + destination.getName());
            Files.delete(original.toPath());
            return 1;
        }
        catch (Exception e) {
            this.handleError(source, new ResourceParseException("Error while converting the file " + original.getName(), e));
            return 0;
        }
    }

    private int repairConfig(S source, class_2960 id) {
        SimpleResource<?> resource = Util.getResource(id);
        if (resource == null) {
            this.sendError(source, "Config resource " + String.valueOf(id) + " does not exist");
            return 0;
        }
        File file = resource.getFile();
        if (!file.exists()) {
            this.sendError(source, "File for config " + String.valueOf(id) + " is missing, reload the config to generate a new one");
            return 0;
        }
        try {
            return this.rewriteConfig(source, resource.getReadWriter(), file);
        }
        catch (Exception e) {
            this.handleError(source, new ResourceParseException("Error while attempting to repair the config " + String.valueOf(id), e));
            return 0;
        }
    }

    private <R> int rewriteConfig(S source, ResourceReadWriter<R> readWriter, File file) throws Exception {
        String fileExtension = Util.getFileExtension(file.getName());
        FileReader reader = new FileReader(file);
        DataResult<R> result = readWriter.read(fileExtension, reader, null);
        reader.close();
        if (result.isSuccess()) {
            this.sendSuccess(source, "Config loaded as a success and does not need repairs");
            return 1;
        }
        Optional partial = result.resultOrPartial();
        if (partial.isEmpty()) {
            this.sendError(source, "Could not load a partial result, repair failed");
            return 0;
        }
        FileWriter writer = new FileWriter(file);
        readWriter.write(fileExtension, writer, partial.get());
        writer.close();
        this.sendSuccess(source, "Wrote the partial result back to the file");
        return 1;
    }

    public void handleError(S source, Exception error) {
        ErrorUtil.sendStackTrace(error, message -> this.sendError(source, (String)message));
    }

    protected void sendSuccess(S source, String message) {
        this.feedbackSender.accept(source, (class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1060));
    }

    protected void sendError(S source, String error) {
        this.feedbackSender.accept(source, (class_2561)class_2561.method_43470((String)error).method_27692(class_124.field_1061));
    }
}

