/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.mixin;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.resources.ResourceUtil;
import cz.yorick.resources.ErrorUtil;
import cz.yorick.resources.loader.CodecResourceReadWriter;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7654;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4309.class})
public class JsonDataLoaderMixin {
    @Inject(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/RegistryKey;Lcom/mojang/serialization/DynamicOps;Lcom/mojang/serialization/Codec;Ljava/util/Map;)V"}, at={@At(value="TAIL")})
    private static <T> void load(class_3300 manager, class_5321<? extends class_2378<T>> registryRef, DynamicOps<JsonElement> ops, Codec<T> codec, Map<class_2960, T> results, CallbackInfo info) {
        if (!(ops instanceof class_6903)) {
            throw new IllegalArgumentException("JsonDataLoaderMixin received a non-registry codec! should never happen!");
        }
        class_6903 registryOps = (class_6903)ops;
        CodecResourceReadWriter.getExtraOps().forEach((extension, parser) -> JsonDataLoaderMixin.loadCustom(manager, new class_7654(class_7924.method_60915((class_5321)registryRef), "." + extension), parser.registryOps(registryOps), codec, results));
    }

    private static <T> void loadCustom(class_3300 resourceManager, class_7654 finder, CodecResourceReadWriter.DynamicOpsParser<?> parser, Codec<T> codec, Map<class_2960, T> results) {
        for (Map.Entry entry : finder.method_45113(resourceManager).entrySet()) {
            try {
                Object parsed = parser.parse(((class_3298)entry.getValue()).method_43039(), codec).getOrThrow();
                class_2960 loadedKey = finder.method_45115((class_2960)entry.getKey());
                if (results.containsKey(loadedKey) && !SimpleResourcesCommon.getPreferredFormat().equals(ResourceUtil.getFileExtension((class_2960)entry.getKey()))) {
                    ErrorUtil.reloadWarning("Duplicate data file ignored with ID " + String.valueOf(loadedKey) + " (path " + String.valueOf(entry.getKey()) + ")");
                    continue;
                }
                results.put(loadedKey, parsed);
            }
            catch (Throwable e) {
                ErrorUtil.reloadError("Error occurred while loading resource: " + ((class_2960)entry.getKey()).toString(), e);
            }
        }
    }

    @WrapOperation(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/resource/ResourceFinder;Lcom/mojang/serialization/DynamicOps;Lcom/mojang/serialization/Codec;Ljava/util/Map;)V", "method_63567(Lnet/minecraft/util/Identifier;Lnet/minecraft/util/Identifier;Lcom/mojang/serialization/DataResult$Error;)V"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;error(Ljava/lang/String;[Ljava/lang/Object;)V", remap=false)})
    private static void sendError(Logger instance, String message, Object[] params, Operation<Void> original) {
        original.call(new Object[]{instance, message, params});
        try {
            ErrorUtil.loggerError(message, params);
        }
        catch (Throwable e) {
            ErrorUtil.reloadError("Failed to send a reload error to chat - original error is logged by minecraft.", e);
        }
    }
}

