/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JacksonOps
implements DynamicOps<JsonNode> {
    public static final JacksonOps INSTANCE = new JacksonOps();

    public JsonNode empty() {
        return JsonNodeFactory.instance.nullNode();
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonNode input) {
        if (input.isObject()) {
            return (U)this.convertMap(outOps, input);
        }
        if (input.isArray()) {
            return (U)this.convertList(outOps, input);
        }
        if (input.isNull()) {
            return (U)outOps.empty();
        }
        if (input.isTextual()) {
            return (U)outOps.createString(input.textValue());
        }
        if (input.isBoolean()) {
            return (U)outOps.createBoolean(input.booleanValue());
        }
        if (input.isNumber()) {
            return (U)outOps.createNumeric(input.numberValue());
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(input));
    }

    public DataResult<Boolean> getBooleanValue(JsonNode input) {
        if (input != null && input.isBoolean()) {
            return DataResult.success((Object)input.booleanValue());
        }
        return DataResult.error(() -> "No a boolean: " + String.valueOf(input));
    }

    public JsonNode createBoolean(boolean value) {
        return JsonNodeFactory.instance.booleanNode(value);
    }

    public DataResult<Number> getNumberValue(JsonNode input) {
        if (input != null && input.isNumber()) {
            return DataResult.success((Object)input.numberValue());
        }
        return DataResult.error(() -> "Not a number " + String.valueOf(input));
    }

    public JsonNode createNumeric(Number number) {
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return JsonNodeFactory.instance.numberNode(b);
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return JsonNodeFactory.instance.numberNode(s);
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return JsonNodeFactory.instance.numberNode(i);
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            return JsonNodeFactory.instance.numberNode(l);
        }
        if (number instanceof BigInteger) {
            BigInteger b = (BigInteger)number;
            return JsonNodeFactory.instance.numberNode(b);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return JsonNodeFactory.instance.numberNode(f);
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return JsonNodeFactory.instance.numberNode(d);
        }
        if (number instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)number;
            return JsonNodeFactory.instance.numberNode(b);
        }
        throw new IllegalArgumentException("Unknown number class: " + String.valueOf(number != null ? number.getClass() : null));
    }

    public DataResult<String> getStringValue(JsonNode input) {
        if (input != null && input.isTextual()) {
            return DataResult.success((Object)input.textValue());
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public JsonNode createString(String value) {
        return JsonNodeFactory.instance.textNode(value);
    }

    public DataResult<JsonNode> mergeToList(JsonNode list, JsonNode value) {
        if (list != null && list.isArray()) {
            ArrayNode result = JsonNodeFactory.instance.arrayNode();
            result.addAll((ArrayNode)list);
            result.add(value);
            return DataResult.success((Object)result);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(list));
    }

    public DataResult<JsonNode> mergeToMap(JsonNode map, JsonNode key, JsonNode value) {
        if (!(map != null && map.isObject() || map == this.empty())) {
            return DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        if (key == null || !key.isTextual()) {
            return DataResult.error(() -> "Map key is not a string: " + String.valueOf(key));
        }
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        if (map != this.empty()) {
            JacksonOps.asStream(map.fields()).forEach(entry -> result.set((String)entry.getKey(), (JsonNode)entry.getValue()));
        }
        result.set(key.asText(), value);
        return DataResult.success((Object)result);
    }

    public DataResult<Stream<Pair<JsonNode, JsonNode>>> getMapValues(JsonNode input) {
        if (input != null && input.isObject()) {
            return DataResult.success(JacksonOps.asStream(input.fields()).map(entry -> Pair.of((Object)JsonNodeFactory.instance.textNode((String)entry.getKey()), (Object)((JsonNode)entry.getValue()))));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    public JsonNode createMap(Stream<Pair<JsonNode, JsonNode>> map) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        map.forEach(pair -> node.set(((JsonNode)pair.getFirst()).asText(), (JsonNode)pair.getSecond()));
        return node;
    }

    public DataResult<Stream<JsonNode>> getStream(JsonNode input) {
        if (input != null && input.isArray()) {
            return DataResult.success(JacksonOps.asStream(input.iterator()));
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(input));
    }

    public JsonNode createList(Stream<JsonNode> input) {
        ArrayNode array = JsonNodeFactory.instance.arrayNode();
        input.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        return array;
    }

    public JsonNode remove(JsonNode input, String key) {
        if (input != null && input.isObject()) {
            ObjectNode result = JsonNodeFactory.instance.objectNode();
            JacksonOps.asStream(input.fields()).filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(entry -> result.set((String)entry.getKey(), (JsonNode)entry.getValue()));
            return result;
        }
        return input;
    }

    private static <T> Stream<T> asStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }
}

