/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.resources;

import cz.yorick.SimpleResourcesCommon;
import cz.yorick.resources.ResourceParseException;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class ErrorUtil {
    private static class_2168 reloadingSource;

    public static void startReload(class_2168 source) {
        reloadingSource = source;
    }

    public static void reloadError(String message, Throwable error) {
        SimpleResourcesCommon.LOGGER.error(message, error);
        ErrorUtil.broadcastReloadError(message, error);
    }

    public static void broadcastReloadError(String message, Throwable error) {
        if (reloadingSource != null && SimpleResourcesCommon.shouldBroadcastErrors()) {
            ErrorUtil.sendStackTrace(new ResourceParseException(message, error), errorLine -> reloadingSource.method_9213((class_2561)class_2561.method_43470((String)errorLine)));
        }
    }

    public static void sendStackTrace(Throwable error, Consumer<String> feedbackConsumer) {
        feedbackConsumer.accept(error.getMessage());
        for (Throwable throwable = error.getCause(); throwable != null; throwable = throwable.getCause()) {
            feedbackConsumer.accept("Caused by " + throwable.getClass().getName() + ":");
            feedbackConsumer.accept(throwable.getMessage());
        }
        SimpleResourcesCommon.LOGGER.error("[ErrorUtil] sending error to chat", error);
    }

    public static void reloadWarning(String message) {
        SimpleResourcesCommon.LOGGER.warn(message);
        if (reloadingSource != null && SimpleResourcesCommon.shouldBroadcastErrors()) {
            reloadingSource.method_45068((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1065));
        }
    }

    public static void loggerError(String string, Object[] args) {
        Object object = args[args.length - 1];
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            FormattingTuple result = MessageFormatter.arrayFormat((String)string, (Object[])Arrays.copyOf(args, args.length - 1));
            ErrorUtil.broadcastReloadError(result.getMessage(), throwable);
            return;
        }
        FormattingTuple result = MessageFormatter.arrayFormat((String)string, (Object[])args);
        ErrorUtil.broadcastReloadError(result.getMessage(), null);
    }
}

