/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.resources;

import cz.yorick.SimpleResourcesCommon;
import cz.yorick.resources.type.SimpleReloadableResource;
import cz.yorick.resources.type.SimpleResource;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class Util {
    private static final Map<class_2960, SimpleResource<?>> resources = new HashMap();
    private static final Map<class_2960, SimpleReloadableResource<?>> reloadableResources = new LinkedHashMap();

    public static <T> Supplier<T> factoryFor(Class<T> clazz) {
        if (clazz.isRecord()) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke the constructor of class " + clazz.getName(), e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " does not have a default (no-argument) constructor!");
        }
    }

    public static String getFileExtensionOrThrow(String path) throws IllegalArgumentException {
        String fileExtension = Util.getFileExtension(path);
        if (fileExtension == null) {
            throw new IllegalArgumentException("File " + path + " does not have a file extension!");
        }
        return fileExtension;
    }

    public static String getFileExtension(String path) {
        String[] paths = path.split("/");
        String fileName = paths[paths.length - 1];
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1 || fileName.endsWith(".")) {
            return null;
        }
        return fileName.substring(lastDotIndex + 1);
    }

    public static String pathToString(Path path) {
        ArrayList<String> files = new ArrayList<String>();
        for (File file = path.toFile(); file != null; file = file.getParentFile()) {
            files.add(file.getName());
        }
        return String.join((CharSequence)"/", files.reversed());
    }

    public static String removeFileExtension(String path) {
        String fileExtension = Util.getFileExtension(path);
        if (fileExtension == null) {
            return path;
        }
        return path.substring(0, path.length() - fileExtension.length() - 1);
    }

    public static void registerConfig(class_2960 id, SimpleResource<?> config) {
        if (resources.containsKey(id)) {
            throw new IllegalArgumentException("Attempted to register a resource with a duplicate id '" + String.valueOf(id) + "'");
        }
        SimpleResourcesCommon.ensureRegistered();
        resources.put(id, config);
        if (config instanceof SimpleReloadableResource) {
            SimpleReloadableResource reloadableResource = (SimpleReloadableResource)config;
            reloadableResources.put(id, reloadableResource);
        }
    }

    public static Collection<class_2960> getReloadableResourceKeys() {
        return List.copyOf(reloadableResources.keySet());
    }

    public static Collection<class_2960> getResourceKeys() {
        return List.copyOf(resources.keySet());
    }

    public static Collection<SimpleReloadableResource<?>> getReloadableResources() {
        return List.copyOf(reloadableResources.values());
    }

    public static SimpleReloadableResource<?> getReloadableResource(class_2960 id) {
        return reloadableResources.get(id);
    }

    public static SimpleResource<?> getResource(class_2960 id) {
        return resources.get(id);
    }
}

