/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.resources.loader;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.FileTypeInitializer;
import cz.yorick.api.resources.ResourceReadWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_3518;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class CodecResourceReadWriter<T>
implements ResourceReadWriter<T> {
    private final Codec<T> codec;
    private final Predicate<String> shouldStripFileExtension;
    private static final HashMap<String, DynamicOpsParser<?>> dynamicOpsRegistry = new HashMap();
    private static final HashMap<String, DynamicOpsParser<?>> extraOps = new HashMap();

    public CodecResourceReadWriter(Codec<T> codec, Predicate<String> shouldStripFileExtension) {
        this.codec = codec;
        this.shouldStripFileExtension = shouldStripFileExtension;
    }

    @Override
    public DataResult<T> read(String fileExtension, Reader reader, @Nullable class_7225.class_7874 wrapperLookup) throws Exception {
        DynamicOpsParser<?> parser = dynamicOpsRegistry.get(fileExtension);
        if (parser == null) {
            throw new IllegalArgumentException("File cannot be parsed - no dynamic ops registered for file extension '." + fileExtension + "', if you wish to use custom extensions register them with SimpleResources#registerOps");
        }
        if (wrapperLookup != null) {
            parser = parser.withLookup(wrapperLookup);
        }
        return parser.parse(reader, this.codec);
    }

    @Override
    public void write(String fileExtension, Writer writer, T data) throws Exception {
        DynamicOpsParser<?> parser = dynamicOpsRegistry.get(fileExtension);
        if (parser == null) {
            throw new IllegalArgumentException("Cannot write to file - no dynamic ops registered for file extension '." + fileExtension + "', if you wish to use custom extensions register them with SimpleResources#registerOps");
        }
        parser.write(writer, data, this.codec);
    }

    @Override
    public boolean shouldStripFileExtension(String fileExtension) {
        return this.shouldStripFileExtension.test(fileExtension);
    }

    public static <T> void registerOps(FileTypeInitializer<T> initializer) {
        String fileExtension = initializer.getExtension();
        if (dynamicOpsRegistry.containsKey(fileExtension)) {
            SimpleResourcesCommon.LOGGER.warn("Attempted to register duplicate DynamicOps for file extension '." + fileExtension + "' ignoring register call - keeping original");
            return;
        }
        DynamicOpsParser<Object> opsParser = new DynamicOpsParser<Object>(initializer.getOps(), initializer::read, initializer::write);
        dynamicOpsRegistry.put(fileExtension, opsParser);
        extraOps.put(fileExtension, opsParser);
    }

    public static Map<String, DynamicOpsParser<?>> getExtraOps() {
        return ImmutableMap.copyOf(extraOps);
    }

    public static Set<String> getRegisteredExtensions() {
        return new HashSet<String>(dynamicOpsRegistry.keySet());
    }

    public static DynamicOpsParser<?> getParser(String extension) {
        return dynamicOpsRegistry.get(extension);
    }

    private static void writeJson(Writer writer, JsonElement data) {
        try {
            JsonWriter jsonWriter = new JsonWriter(writer);
            jsonWriter.setIndent("  ");
            jsonWriter.setSerializeNulls(false);
            class_3518.method_43677((JsonWriter)jsonWriter, (JsonElement)data, (string1, string2) -> 0);
            jsonWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing json to file", e);
        }
    }

    static {
        dynamicOpsRegistry.put("json", new DynamicOpsParser<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, JsonParser::parseReader, CodecResourceReadWriter::writeJson));
    }

    public record DynamicOpsParser<T>(DynamicOps<T> ops, OpsReader<T> readerParser, OpsWriter<T> writer) {
        public <V> DataResult<V> parse(Reader reader, Codec<V> codec) throws Exception {
            return codec.parse(this.ops, this.readerParser.read(reader));
        }

        public <V> void write(Writer writer, V value, Codec<V> codec) throws Exception {
            DataResult encodeResult = codec.encodeStart(this.ops, value);
            this.writer.write(writer, encodeResult.getOrThrow());
        }

        public DynamicOpsParser<T> registryOps(class_6903<?> registryOps) {
            return new DynamicOpsParser<T>(registryOps.method_57110(this.ops), this.readerParser, this.writer);
        }

        public DynamicOpsParser<T> withLookup(class_7225.class_7874 lookup) {
            return new DynamicOpsParser<T>(lookup.method_57093(this.ops), this.readerParser, this.writer);
        }

        public <T2> void convertTo(DynamicOpsParser<T2> other, Reader reader, Writer writer) throws Exception {
            T result = this.readerParser.read(reader);
            Object converted = this.ops.convertTo(other.ops(), result);
            other.writer().write(writer, converted);
        }
    }

    public static interface OpsReader<T> {
        public T read(Reader var1) throws Exception;
    }

    public static interface OpsWriter<T> {
        public void write(Writer var1, T var2) throws Exception;
    }
}

