/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.resources.loader;

import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.resources.ResourceReadWriter;
import cz.yorick.resources.ResourceParseException;
import cz.yorick.resources.Util;
import cz.yorick.resources.type.SimpleResource;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ResourceFileLoader<T>
implements SimpleResource.Loader<T> {
    private final Supplier<T> defaultFactory;
    private final ResourceReadWriter<T> readWriter;

    public ResourceFileLoader(Supplier<T> defaultFactory, ResourceReadWriter<T> readWriter) {
        this.defaultFactory = defaultFactory;
        this.readWriter = readWriter;
    }

    @Override
    public T load(Path path, Consumer<ResourceParseException> errorHandler) {
        try {
            File file = ResourceFileLoader.getFile(path);
            if (file == null) {
                T defaultValue = this.defaultFactory.get();
                File newFile = ResourceFileLoader.getFile(path);
                this.readWriter.write(Util.getFileExtensionOrThrow(newFile.getName()), new FileWriter(newFile), defaultValue);
                SimpleResourcesCommon.LOGGER.info("Wrote default data to file " + String.valueOf(newFile));
                return defaultValue;
            }
            return (T)this.readWriter.read(Util.getFileExtensionOrThrow(Util.pathToString(path)), new FileReader(file), null).getOrThrow();
        }
        catch (Throwable e) {
            errorHandler.accept(new ResourceParseException("Error while loading the file " + String.valueOf(SimpleResource.Loader.getRelativePath(path)), e));
            return this.defaultFactory.get();
        }
    }

    private static File getFile(Path path) throws IOException {
        File file = path.toFile();
        if (file.exists()) {
            if (!file.isFile()) {
                throw new FileAlreadyExistsException("File found in the specified location " + String.valueOf(SimpleResource.Loader.getRelativePath(path)) + " but it is not a normal file!");
            }
            return file;
        }
        if (!file.getParentFile().exists()) {
            SimpleResourcesCommon.LOGGER.info("File " + String.valueOf(SimpleResource.Loader.getRelativePath(path)) + " is missing parents, creating...");
            if (!file.getParentFile().mkdirs()) {
                throw new IOException("Could not crate the parent directories for file " + String.valueOf(SimpleResource.Loader.getRelativePath(path)));
            }
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create the file " + String.valueOf(SimpleResource.Loader.getRelativePath(path)));
        }
        SimpleResourcesCommon.LOGGER.info("File missing, created new file " + String.valueOf(file));
        return null;
    }

    @Override
    public ResourceReadWriter<T> getReadWriter() {
        return this.readWriter;
    }

    @Override
    public Path getFilePath(Path path, String name) {
        String jsonFile;
        File preferredFile = path.resolve(name + "." + SimpleResourcesCommon.getPreferredFormat()).toFile();
        if (preferredFile.exists()) {
            return preferredFile.toPath();
        }
        String[] files = path.toFile().list((dir, fileName) -> this.isValidName(name, fileName));
        if (files == null) {
            return preferredFile.toPath();
        }
        List<String> validFiles = Arrays.asList(files);
        if (validFiles.contains(jsonFile = name + ".json")) {
            return path.resolve(jsonFile);
        }
        if (!validFiles.isEmpty()) {
            return path.resolve(validFiles.getFirst());
        }
        return preferredFile.toPath();
    }

    private boolean isValidName(String configName, String fileName) {
        String fileExtension = Util.getFileExtension(fileName);
        if (fileExtension == null) {
            return false;
        }
        return configName.equals(Util.removeFileExtension(fileName));
    }
}

