/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.resources.loader;

import com.google.common.collect.ImmutableMap;
import cz.yorick.api.resources.ResourceReadWriter;
import cz.yorick.resources.ResourceParseException;
import cz.yorick.resources.Util;
import cz.yorick.resources.loader.ResourceFileLoader;
import cz.yorick.resources.type.SimpleResource;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ResourceTreeLoader<T>
implements SimpleResource.Loader<Map<String, T>> {
    private final ResourceFileLoader<T> fileLoader;
    private final Predicate<String> shouldStripExtension;

    public ResourceTreeLoader(ResourceReadWriter<T> readWriter) {
        this.fileLoader = new ResourceFileLoader<Object>(() -> null, readWriter);
        this.shouldStripExtension = readWriter::shouldStripFileExtension;
    }

    @Override
    public Map<String, T> load(final Path path, final Consumer<ResourceParseException> errorHandler) {
        File file = path.toFile();
        if (!file.exists() && !path.toFile().mkdirs()) {
            errorHandler.accept(new ResourceParseException("Failed to create the directory and parent directories at " + String.valueOf(SimpleResource.Loader.getRelativePath(path))));
            return ImmutableMap.of();
        }
        final HashMap results = new HashMap();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Object loadedValue = ResourceTreeLoader.this.fileLoader.load(file, errorHandler);
                    if (loadedValue == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path relativePath = path.relativize(file);
                    String path2 = Util.pathToString(relativePath);
                    if (ResourceTreeLoader.this.shouldStripExtension.test(Util.getFileExtension(path2))) {
                        path2 = Util.removeFileExtension(path2);
                    }
                    results.put(Util.removeFileExtension(path2), loadedValue);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            errorHandler.accept(new ResourceParseException("Fatal error occurred while loading directory " + String.valueOf(SimpleResource.Loader.getRelativePath(path)) + " returning only partial result", e));
        }
        return ImmutableMap.copyOf(results);
    }

    @Override
    public ResourceReadWriter<?> getReadWriter() {
        return this.fileLoader.getReadWriter();
    }

    @Override
    public Path getFilePath(Path path, String name) {
        return path.resolve(name);
    }
}

