/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.resources.type;

import com.google.common.collect.ImmutableMap;
import cz.yorick.SimpleResourcesCommon;
import cz.yorick.api.resources.ResourceKey;
import cz.yorick.api.resources.ResourceReadWriter;
import cz.yorick.api.resources.ResourceUtil;
import cz.yorick.resources.ErrorUtil;
import cz.yorick.resources.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7225;

public class MinecraftResource<T>
implements ResourceKey<Map<class_2960, T>> {
    private final Consumer<Map<class_2960, T>> reloadListener;
    private Map<class_2960, T> loadedValue = ImmutableMap.of();

    public MinecraftResource(class_2960 id, ResourceReadWriter<T> readWriter, class_3264 resourceType, Consumer<Map<class_2960, T>> reloadListener, class_2960 ... dependencies) {
        this.reloadListener = reloadListener;
        if (resourceType == class_3264.field_14188) {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this.getListener(id, readWriter, null, dependencies));
            return;
        }
        ResourceManagerHelper.get((class_3264)resourceType).registerReloadListener(id, wrapperLookup -> this.getListener(id, readWriter, (class_7225.class_7874)wrapperLookup, dependencies));
    }

    @Override
    public Map<class_2960, T> getValue() {
        return this.loadedValue;
    }

    private void parse(String resourceName, class_3300 resourceManager, ResourceReadWriter<T> readWriter, class_7225.class_7874 wrapperLookup) {
        HashMap<class_2960, Object> results = new HashMap<class_2960, Object>();
        for (Map.Entry entry : resourceManager.method_14488(resourceName, identifier -> true).entrySet()) {
            try {
                class_2960 originalKey = (class_2960)entry.getKey();
                String fileExtension = Util.getFileExtensionOrThrow(originalKey.method_12832());
                Object parsed = readWriter.read(fileExtension, ((class_3298)entry.getValue()).method_43039(), wrapperLookup).getOrThrow();
                class_2960 loadedKey = originalKey.method_45136(originalKey.method_12832().substring(resourceName.length() + 1));
                if (readWriter.shouldStripFileExtension(fileExtension)) {
                    loadedKey = ResourceUtil.removeFileExtension(loadedKey);
                }
                if (results.containsKey(loadedKey) && !fileExtension.equals(SimpleResourcesCommon.getPreferredFormat())) {
                    ErrorUtil.reloadWarning("Duplicate data file ignored with ID " + String.valueOf(loadedKey) + " (path " + String.valueOf(originalKey) + ")");
                    continue;
                }
                results.put(loadedKey, parsed);
            }
            catch (Throwable e) {
                ErrorUtil.reloadError("Error occurred while loading resource: " + ((class_2960)entry.getKey()).toString(), e);
            }
        }
        this.loadedValue = ImmutableMap.copyOf(results);
        this.reloadListener.accept(this.loadedValue);
    }

    private SimpleSynchronousResourceReloadListener getListener(final class_2960 id, final ResourceReadWriter<T> readWriter, final class_7225.class_7874 lookup, class_2960 ... dependencies) {
        final List<class_2960> fabricDependencies = Arrays.stream(dependencies).toList();
        return new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return id;
            }

            public void method_14491(class_3300 manager) {
                MinecraftResource.this.parse(id.method_12832(), manager, readWriter, lookup);
            }

            public Collection<class_2960> getFabricDependencies() {
                return fabricDependencies;
            }
        };
    }
}

