/*
 * Decompiled with CFR 0.152.
 */
package net.eagle.ancientartifacts.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.eagle.ancientartifacts.block.custom.EtherLever;
import net.minecraft.class_10;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CopperWire
extends class_2248
implements class_3737 {
    public static final class_2746 WATERLOGGED;
    public static final class_2753 FACING;
    public static final class_2746 WIRE_CONNECTION_NORTH;
    public static final class_2746 WIRE_CONNECTION_SOUTH;
    public static final class_2746 WIRE_CONNECTION_EAST;
    public static final class_2746 WIRE_CONNECTION_WEST;
    public static final class_2746 WIRE_CONNECTION_UP;
    public static final class_2746 WIRE_CONNECTION_DOWN;
    public static final class_2746 IS_ROOT;
    public static final class_2746 IS_POWERED;
    public static final class_2758 POWER;
    protected static final class_265 ROD_X_SHAPE;
    protected static final class_265 ROD_Y_SHAPE;
    protected static final class_265 ROD_Z_SHAPE;
    private static final Map<class_2350, class_265> DIRECTION_TO_SIDE_SHAPE;
    private static final Map<class_2680, class_265> SHAPES;
    public static final Map<class_2350, class_2746> DIRECTION_TO_WIRE_CONNECTION_PROPERTY;

    public CopperWire(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)IS_ROOT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)WIRE_CONNECTION_DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WIRE_CONNECTION_UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WIRE_CONNECTION_NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WIRE_CONNECTION_SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WIRE_CONNECTION_EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WIRE_CONNECTION_WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0)));
        for (class_2680 blockState : this.method_9595().method_11662()) {
            if ((Integer)blockState.method_11654((class_2769)POWER) != 0) continue;
            SHAPES.put(blockState, this.getShapeForState(blockState));
        }
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false)));
    }

    private class_265 getShapeForState(class_2680 state) {
        class_265 shape = this.getBaseShape(state);
        for (class_2350 direction : class_2350.values()) {
            if (!((Boolean)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).booleanValue()) continue;
            class_265 tempShape = DIRECTION_TO_SIDE_SHAPE.get(direction);
            shape = class_259.method_1084((class_265)tempShape, (class_265)shape);
        }
        return shape;
    }

    public class_265 getBaseShape(class_2680 state) {
        switch (((class_2350)state.method_11654((class_2769)FACING)).method_10166()) {
            default: {
                return ROD_X_SHAPE;
            }
            case field_11051: {
                return ROD_Z_SHAPE;
            }
            case field_11052: 
        }
        return ROD_Y_SHAPE;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        boolean waterlogged = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.getPlacementState(ctx.method_8045(), this.method_9564(), ctx.method_8037()).method_11657((class_2769)FACING, (Comparable)ctx.method_8038())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private class_2680 getPlacementState(class_1937 world, class_2680 state, class_2338 pos) {
        int strongestPower = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_26204() == class_2246.field_27119 || neighborState.method_26204() == class_2246.field_27133) {
                class_2338 leverPos = this.findEtherLever(world, neighborPos);
                class_2680 leverPowerState = world.method_8320(leverPos);
                if (leverPos != pos && leverPowerState.method_26204() instanceof EtherLever) {
                    state = (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)IS_ROOT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(world.method_49804(neighborPos)));
                    continue;
                }
                state = (class_2680)((class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)IS_ROOT, (Comparable)Boolean.valueOf(false));
                continue;
            }
            if (neighborState.method_26204() instanceof CopperWire) {
                state = (class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)Boolean.valueOf(true));
                world.method_8652(neighborPos, (class_2680)neighborState.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction.method_10153()), (Comparable)Boolean.valueOf(true)), 3);
                continue;
            }
            if (!neighborState.method_26212((class_1922)world, neighborPos)) continue;
            state = (class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)Boolean.valueOf(true));
        }
        strongestPower = this.getStrongestRestonePower(world, pos);
        if (strongestPower == 0) {
            state = (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(strongestPower));
        } else {
            state = (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(strongestPower - 1));
            world.method_20290(3002, pos, ((class_2350)state.method_11654((class_2769)FACING)).method_10166().ordinal());
        }
        state = (Integer)state.method_11654((class_2769)POWER) > 0 ? (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(true)) : (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(world, pos, state, player);
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (!(neighborState.method_26204() instanceof CopperWire)) continue;
            if (((Boolean)state.method_11654((class_2769)IS_ROOT)).booleanValue()) {
                updatedNeighborState = (class_2680)((class_2680)((class_2680)neighborState.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction.method_10153()), (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false));
                world.method_8652(neighborPos, updatedNeighborState, 3);
            } else {
                updatedNeighborState = (class_2680)neighborState.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction.method_10153()), (Comparable)Boolean.valueOf(false));
                world.method_8652(neighborPos, updatedNeighborState, 3);
            }
            this.updateNeighbors(world, pos);
        }
        return state;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_27852(state.method_26204()) || world.field_9236) {
            return;
        }
        this.updateNeighbors(world, pos);
        for (class_2350 direction : class_2350.values()) {
            world.method_8452(pos.method_10093(direction), (class_2248)this);
        }
        this.updateOffsetNeighbors(world, pos);
    }

    private void updateOffsetNeighbors(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            this.updateNeighbors(world, pos.method_10093(direction));
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockPos = pos.method_10093(direction);
            if (world.method_8320(blockPos).method_26212((class_1922)world, blockPos)) {
                this.updateNeighbors(world, blockPos.method_10084());
                continue;
            }
            this.updateNeighbors(world, blockPos.method_10074());
        }
    }

    private void updateNeighbors(class_1937 world, class_2338 pos) {
        world.method_8452(pos, (class_2248)this);
        for (class_2350 direction : class_2350.values()) {
            world.method_8452(pos.method_10093(direction), (class_2248)this);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        class_2338 neighborPos;
        super.method_9612(state, world, pos, block, fromPos, notify);
        int netPower = 0;
        class_2680 copperPowerState = world.method_8320(fromPos);
        class_2680 fromState = world.method_8320(fromPos);
        if (copperPowerState.method_26204() == class_2246.field_27119 || copperPowerState.method_26204() == class_2246.field_27133) {
            class_2338 leverPos = this.findEtherLever(world, fromPos);
            class_2680 leverState = world.method_8320(leverPos);
            if (leverState.method_26204() instanceof EtherLever) {
                netPower = world.method_49804(fromPos);
                if ((Integer)(state = (class_2680)((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(netPower))).method_11657((class_2769)IS_ROOT, (Comparable)Boolean.valueOf(true))).method_11654((class_2769)POWER) > 0) {
                    state = (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(true));
                    world.method_20290(3002, pos, ((class_2350)state.method_11654((class_2769)FACING)).method_10166().ordinal());
                } else {
                    state = (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false));
                }
                world.method_8652(pos, state, 3);
                return;
            }
            state = (Integer)(state = (class_2680)((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(netPower))).method_11657((class_2769)IS_ROOT, (Comparable)Boolean.valueOf(false))).method_11654((class_2769)POWER) > 0 ? (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(true)) : (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false));
            world.method_8652(pos, state, 3);
            return;
        }
        if (fromState.method_26204() instanceof CopperWire && !((Boolean)state.method_11654((class_2769)IS_ROOT)).booleanValue()) {
            int strongestPower = this.getStrongestRestonePower(world, pos);
            for (class_2350 direction : class_2350.values()) {
                neighborPos = pos.method_10093(direction);
                class_2680 neighborState = world.method_8320(neighborPos);
                if (!(neighborState.method_26204() instanceof CopperWire)) continue;
                int powerRecieved = world.method_49808(pos.method_10093(direction), direction);
                strongestPower = Math.max(strongestPower, powerRecieved);
            }
            state = strongestPower == 0 ? (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(strongestPower)) : (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(strongestPower - 1));
        }
        if (((Boolean)(state = (Integer)state.method_11654((class_2769)POWER) > 0 ? (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(true)) : (class_2680)state.method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false))).method_11654((class_2769)IS_ROOT)).booleanValue()) {
            boolean hasCopperBlockNeighbor = false;
            for (class_2350 direction : class_2350.values()) {
                neighborPos = pos.method_10093(direction);
                if (world.method_8320(neighborPos).method_26204() != class_2246.field_27119 && world.method_8320(neighborPos).method_26204() != class_2246.field_27133) continue;
                hasCopperBlockNeighbor = true;
                break;
            }
            if (!hasCopperBlockNeighbor) {
                state = (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IS_ROOT, (Comparable)Boolean.valueOf(false));
            }
        } else {
            boolean hasCopperWireNeighbors = false;
            for (class_2350 direction : class_2350.values()) {
                neighborPos = pos.method_10093(direction);
                if (!(world.method_8320(neighborPos).method_26204() instanceof CopperWire)) continue;
                hasCopperWireNeighbors = true;
                break;
            }
            if (!hasCopperWireNeighbors) {
                state = (class_2680)((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)IS_POWERED, (Comparable)Boolean.valueOf(false));
            }
        }
        world.method_8652(pos, state, 3);
    }

    private int getStrongestRestonePower(class_1937 world, class_2338 pos) {
        int strongestPower = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (!(neighborState.method_26204() instanceof CopperWire)) continue;
            int powerReceived = (Integer)neighborState.method_11654((class_2769)POWER);
            strongestPower = Math.max(strongestPower, powerReceived);
        }
        return strongestPower;
    }

    private class_2338 findEtherLever(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 leverPos = pos.method_10093(direction);
            class_2680 leverState = world.method_8320(leverPos);
            if (!(leverState.method_26204() instanceof EtherLever)) continue;
            return leverPos;
        }
        return pos;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved || state.method_27852(newState.method_26204())) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
        if (world.field_9236) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            world.method_8452(pos.method_10093(direction), (class_2248)this);
        }
        this.updateNeighbors(world, pos);
        this.updateOffsetNeighbors(world, pos);
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if ((Integer)state.method_11654((class_2769)POWER) == 0) {
            return 0;
        }
        if (((Boolean)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).booleanValue()) {
            return (Integer)state.method_11654((class_2769)POWER);
        }
        return 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_26195(world, pos, direction);
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{IS_ROOT, WATERLOGGED, IS_POWERED, POWER, FACING, WIRE_CONNECTION_NORTH, WIRE_CONNECTION_SOUTH, WIRE_CONNECTION_EAST, WIRE_CONNECTION_WEST, WIRE_CONNECTION_UP, WIRE_CONNECTION_DOWN});
    }

    static {
        WIRE_CONNECTION_NORTH = class_2741.field_12489;
        WIRE_CONNECTION_SOUTH = class_2741.field_12540;
        WIRE_CONNECTION_EAST = class_2741.field_12487;
        WIRE_CONNECTION_WEST = class_2741.field_12527;
        WIRE_CONNECTION_UP = class_2741.field_12519;
        WIRE_CONNECTION_DOWN = class_2741.field_12546;
        POWER = class_2758.method_11867((String)"power", (int)0, (int)15);
        SHAPES = Maps.newHashMap();
        DIRECTION_TO_WIRE_CONNECTION_PROPERTY = Maps.newHashMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)WIRE_CONNECTION_NORTH, (Object)class_2350.field_11034, (Object)WIRE_CONNECTION_EAST, (Object)class_2350.field_11035, (Object)WIRE_CONNECTION_SOUTH, (Object)class_2350.field_11039, (Object)WIRE_CONNECTION_WEST, (Object)class_2350.field_11036, (Object)WIRE_CONNECTION_UP, (Object)class_2350.field_11033, (Object)WIRE_CONNECTION_DOWN));
        WATERLOGGED = class_2741.field_12508;
        FACING = class_2741.field_12525;
        IS_ROOT = class_2746.method_11825((String)"is_root");
        IS_POWERED = class_2746.method_11825((String)"is_powered");
        class_265 vx1 = class_2248.method_9541((double)0.0, (double)6.3, (double)6.3, (double)2.5, (double)9.7, (double)9.7);
        class_265 vx2 = class_2248.method_9541((double)2.5, (double)7.0, (double)7.0, (double)13.5, (double)9.0, (double)9.0);
        class_265 vx3 = class_2248.method_9541((double)13.5, (double)6.3, (double)6.3, (double)16.0, (double)9.7, (double)9.7);
        ROD_X_SHAPE = class_259.method_17786((class_265)vx1, (class_265[])new class_265[]{vx2, vx3}).method_1097();
        class_265 vy1 = class_2248.method_9541((double)6.3, (double)0.0, (double)6.3, (double)9.7, (double)2.5, (double)9.7);
        class_265 vy2 = class_2248.method_9541((double)7.0, (double)2.5, (double)7.0, (double)9.0, (double)13.5, (double)9.0);
        class_265 vy3 = class_2248.method_9541((double)6.3, (double)13.5, (double)6.3, (double)9.7, (double)16.0, (double)9.7);
        ROD_Y_SHAPE = class_259.method_17786((class_265)vy1, (class_265[])new class_265[]{vy2, vy3}).method_1097();
        class_265 vz1 = class_2248.method_9541((double)6.3, (double)6.3, (double)0.0, (double)9.7, (double)9.7, (double)2.5);
        class_265 vz2 = class_2248.method_9541((double)7.0, (double)7.0, (double)2.5, (double)9.0, (double)9.0, (double)13.5);
        class_265 vz3 = class_2248.method_9541((double)6.3, (double)6.3, (double)13.5, (double)9.7, (double)9.7, (double)16.0);
        ROD_Z_SHAPE = class_259.method_17786((class_265)vz1, (class_265[])new class_265[]{vz2, vz3}).method_1097();
        DIRECTION_TO_SIDE_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)ROD_Z_SHAPE, (Object)class_2350.field_11035, (Object)ROD_Z_SHAPE, (Object)class_2350.field_11034, (Object)ROD_X_SHAPE, (Object)class_2350.field_11039, (Object)ROD_X_SHAPE, (Object)class_2350.field_11036, (Object)ROD_Y_SHAPE, (Object)class_2350.field_11033, (Object)ROD_Y_SHAPE));
    }
}

