/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bonapart.client.renderer;

import net.mcreator.bonapart.client.model.ModelBonapart;
import net.mcreator.bonapart.client.model.animations.BonapartAnimation;
import net.mcreator.bonapart.entity.BonapartEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BonapartRenderer
extends MobRenderer<BonapartEntity, LivingEntityRenderState, ModelBonapart> {
    private BonapartEntity entity = null;

    public BonapartRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBonapart.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BonapartEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"bonapart:textures/entities/bonapart_texture.png");
    }

    private static final class AnimatedModel
    extends ModelBonapart {
        private BonapartEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = BonapartAnimation.walk.bake(root);
            this.keyframeAnimation1 = BonapartAnimation.idle.bake(root);
            this.keyframeAnimation2 = BonapartAnimation.idle.bake(root);
        }

        public void setEntity(BonapartEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

