/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Map;
import java.util.UUID;
import main.CustomAnchorManager;
import main.TPRCommand;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnchorIsolation
implements Listener {
    private final JavaPlugin plugin;
    private final CustomAnchorManager anchorManager;
    private final TPRCommand tpr;

    public AnchorIsolation(CustomAnchorManager manager, TPRCommand tpr, JavaPlugin plugin) {
        this.anchorManager = manager;
        this.tpr = tpr;
        this.plugin = plugin;
    }

    @EventHandler
    public void onChargeAnchor(final PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.RESPAWN_ANCHOR) {
            return;
        }
        final World world = block.getWorld();
        if (!world.getName().startsWith("skygridx_")) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Block b = world.getBlockAt(block.getX(), block.getY(), block.getZ());
                if (b.getType() != Material.RESPAWN_ANCHOR) {
                    return;
                }
                RespawnAnchor data = (RespawnAnchor)b.getBlockData();
                if (data.getCharges() == 0) {
                    AnchorIsolation.this.anchorManager.removeCustomAnchor(event.getPlayer().getUniqueId());
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onSetSpawnAnchor(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.RESPAWN_ANCHOR) {
            return;
        }
        World world = block.getWorld();
        if (!world.getName().startsWith("skygridx_")) {
            return;
        }
        if (event.getItem() != null && event.getItem().getType() == Material.GLOWSTONE) {
            return;
        }
        RespawnAnchor data = (RespawnAnchor)block.getBlockData();
        if (data.getCharges() > 0) {
            this.anchorManager.setCustomAnchor(event.getPlayer(), block.getLocation());
        }
    }

    @EventHandler
    public void onAnchorBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.RESPAWN_ANCHOR) {
            return;
        }
        World world = block.getWorld();
        if (!world.getName().startsWith("skygridx_")) {
            return;
        }
        Location loc = block.getLocation();
        UUID toRemove = null;
        for (Map.Entry<UUID, Location> entry : this.anchorManager.getAllAnchors().entrySet()) {
            Location stored = entry.getValue();
            if (!stored.getWorld().equals((Object)loc.getWorld()) || stored.getBlockX() != loc.getBlockX() || stored.getBlockY() != loc.getBlockY() || stored.getBlockZ() != loc.getBlockZ()) continue;
            toRemove = entry.getKey();
            break;
        }
        if (toRemove != null) {
            this.anchorManager.removeCustomAnchor(toRemove);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCustomRespawn(PlayerRespawnEvent event) {
        World targetWorld;
        Location targetLoc;
        final Player player = event.getPlayer();
        World deathWorld = player.getWorld();
        if (!deathWorld.getName().startsWith("skygridx_")) {
            return;
        }
        final UUID id = player.getUniqueId();
        if (this.anchorManager.hasCustomAnchor(id)) {
            targetLoc = this.anchorManager.getCustomAnchor(id);
            if (targetLoc == null) {
                return;
            }
            targetWorld = targetLoc.getWorld();
        } else {
            targetWorld = Bukkit.getWorld((String)"skygridx_world");
            if (targetWorld == null) {
                return;
            }
            targetLoc = targetWorld.getSpawnLocation();
        }
        event.setRespawnLocation(new Location(targetWorld, (double)targetLoc.getBlockX() + 0.5, (double)targetLoc.getBlockY(), (double)targetLoc.getBlockZ() + 0.5));
        new BukkitRunnable(){

            public void run() {
                AnchorIsolation.this.tpr.findNonAirBlock(player, targetWorld, targetLoc.getBlockX(), targetLoc.getBlockY(), targetLoc.getBlockZ(), true);
                Block b = targetWorld.getBlockAt(targetLoc.getBlockX(), targetLoc.getBlockY(), targetLoc.getBlockZ());
                if (b.getType() != Material.RESPAWN_ANCHOR) {
                    AnchorIsolation.this.anchorManager.removeCustomAnchor(id);
                } else {
                    RespawnAnchor d = (RespawnAnchor)b.getBlockData();
                    if (d.getCharges() == 0) {
                        AnchorIsolation.this.anchorManager.removeCustomAnchor(id);
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 2L);
    }
}

