/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class AsyncDelayedScheduler {
    private final AtomicBoolean isEnabled = new AtomicBoolean(true);
    private static final int maxTasks = ForkJoinPool.commonPool().getParallelism();
    private final Runnable[] taskBatch = new Runnable[maxTasks];
    private int taskCount = 0;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWithDelay(Runnable task, long delay, TimeUnit unit) {
        Object object = this.lock;
        synchronized (object) {
            if (this.taskCount == this.taskBatch.length) {
                Runnable[] tasksToRun = new Runnable[this.taskCount];
                System.arraycopy(this.taskBatch, 0, tasksToRun, 0, this.taskCount);
                this.taskCount = 0;
                this.scheduleBatchWithDelay(tasksToRun, tasksToRun.length, 0L, unit);
            }
            this.taskBatch[this.taskCount++] = task;
        }
        CompletableFuture.delayedExecutor(delay, unit, ForkJoinPool.commonPool()).execute(() -> {
            int tasksToRunCount;
            Runnable[] tasksToRun;
            Object object = this.lock;
            synchronized (object) {
                tasksToRun = new Runnable[this.taskCount];
                System.arraycopy(this.taskBatch, 0, tasksToRun, 0, this.taskCount);
                tasksToRunCount = this.taskCount;
                this.taskCount = 0;
            }
            this.scheduleBatchWithDelay(tasksToRun, tasksToRunCount, 0L, unit);
        });
    }

    public void scheduleBatchWithDelay(Runnable[] tasks, int count, long delay, TimeUnit unit) {
        CompletableFuture.delayedExecutor(delay, unit, ForkJoinPool.commonPool()).execute(() -> {
            if (this.isEnabled.get()) {
                for (int i = 0; i < count; ++i) {
                    try {
                        tasks[i].run();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit, Supplier<Boolean> isEnabledSupplier) {
        CompletableFuture.delayedExecutor(initialDelay, unit, ForkJoinPool.commonPool()).execute(() -> {
            if (((Boolean)isEnabledSupplier.get()).booleanValue()) {
                try {
                    task.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.scheduleAtFixedRate(task, period, period, unit, isEnabledSupplier);
        });
    }

    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        this.scheduleAtFixedRate(task, initialDelay, period, unit, this::isEnabled);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.isEnabled.get();
    }

    public Supplier<Boolean> isEnabledSupplier() {
        return this.isEnabled::get;
    }
}

