/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Map;
import java.util.UUID;
import main.CustomBedManager;
import main.TPRCommand;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BedIsolation
implements Listener {
    private final JavaPlugin plugin;
    private final CustomBedManager bedManager;
    private final TPRCommand tpr;

    public BedIsolation(CustomBedManager manager, TPRCommand tpr, JavaPlugin plugin) {
        this.bedManager = manager;
        this.tpr = tpr;
        this.plugin = plugin;
    }

    @EventHandler
    public void onSetCustomBed(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Material mat = event.getClickedBlock().getType();
        if (!mat.name().endsWith("_BED")) {
            return;
        }
        World world = event.getClickedBlock().getWorld();
        if (!world.getName().startsWith("skygridx_")) {
            return;
        }
        BlockData data = event.getClickedBlock().getBlockData();
        if (data instanceof Bed) {
            Bed bed = (Bed)data;
            Location footLoc = bed.getPart() == Bed.Part.HEAD ? event.getClickedBlock().getRelative(bed.getFacing().getOppositeFace()).getLocation() : event.getClickedBlock().getLocation();
            this.bedManager.setCustomBed(event.getPlayer(), footLoc);
        }
    }

    @EventHandler
    public void onBedBreak(BlockBreakEvent event) {
        Bed bed;
        if (!event.getBlock().getType().name().endsWith("_BED")) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        World world = loc.getWorld();
        if (!world.getName().startsWith("skygridx_")) {
            return;
        }
        BlockData data = event.getBlock().getBlockData();
        Location footLoc = data instanceof Bed ? ((bed = (Bed)data).getPart() == Bed.Part.HEAD ? event.getBlock().getRelative(bed.getFacing().getOppositeFace()).getLocation() : event.getBlock().getLocation()) : event.getBlock().getLocation();
        UUID toRemove = null;
        for (Map.Entry<UUID, Location> entry : this.bedManager.getAllBeds().entrySet()) {
            Location stored = entry.getValue();
            if (!stored.getWorld().equals((Object)footLoc.getWorld()) || stored.getBlockX() != footLoc.getBlockX() || stored.getBlockY() != footLoc.getBlockY() || stored.getBlockZ() != footLoc.getBlockZ()) continue;
            toRemove = entry.getKey();
            break;
        }
        if (toRemove != null) {
            this.bedManager.removeCustomBed(toRemove);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCustomRespawn(PlayerRespawnEvent event) {
        World targetWorld;
        Location targetLoc;
        final Player player = event.getPlayer();
        World deathWorld = player.getWorld();
        if (!deathWorld.getName().startsWith("skygridx_")) {
            return;
        }
        UUID id = player.getUniqueId();
        if (this.bedManager.hasCustomBed(id)) {
            targetLoc = this.bedManager.getCustomBed(id);
            if (targetLoc == null) {
                return;
            }
            targetWorld = targetLoc.getWorld();
        } else {
            String customName = "skygridx_world";
            targetWorld = Bukkit.getWorld((String)customName);
            if (targetWorld == null) {
                return;
            }
            targetLoc = targetWorld.getSpawnLocation();
        }
        event.setRespawnLocation(new Location(targetWorld, (double)targetLoc.getBlockX() + 0.5, (double)targetLoc.getBlockY(), (double)targetLoc.getBlockZ() + 0.5));
        new BukkitRunnable(){

            public void run() {
                BedIsolation.this.tpr.findNonAirBlock(player, targetWorld, targetLoc.getBlockX(), targetLoc.getBlockY(), targetLoc.getBlockZ(), true);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }
}

