/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.ChestRegionData;
import main.CustomChest;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.loot.LootTable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestOpenListener
implements Listener {
    private final JavaPlugin plugin;
    private final ChestRegionData regionData;

    public ChestOpenListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.regionData = ChestRegionData.getInstance(plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().toString().contains("RIGHT_CLICK_BLOCK")) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)blockState;
        ChestRegionData.ChestInfo info = this.regionData.getChestInfo(chest.getLocation());
        if (info != null) {
            if (info.type == ChestRegionData.ChestType.CUSTOM) {
                CustomChest.getInstance(this.plugin).populateChestOnOpen(chest, info);
                this.regionData.markChestLooted(chest.getLocation());
            } else if (info.type == ChestRegionData.ChestType.VANILLA) {
                LootTable table = this.plugin.getServer().getLootTable(NamespacedKey.fromString((String)info.lootTableKey));
                if (table != null) {
                    chest.setLootTable(table);
                    chest.update();
                }
                this.regionData.markChestLooted(chest.getLocation());
            }
            return;
        }
        Byte unpopulated = (Byte)chest.getPersistentDataContainer().get(CustomChest.UNPOPULATED_KEY, PersistentDataType.BYTE);
        if (unpopulated == null || unpopulated != 1) {
            return;
        }
        chest.getPersistentDataContainer().remove(CustomChest.UNPOPULATED_KEY);
        chest.update();
        CustomChest.getInstance(this.plugin).populateLegacyChestOnOpen(chest);
    }
}

