/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import main.Cc;
import main.SkyGridPlugin;
import main.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkLoader {
    private final JavaPlugin plugin;
    private static final boolean IS_PAPER = ChunkLoader.detectPaper();
    private static final String WAIT_MESSAGE = Cc.logO(Cc.DARK_GREEN, "Please wait a couple seconds while we force load spawn chunks to ensure proper generation");
    private static final String READY_MESSAGE = Cc.logO(Cc.DARK_GREEN, "Chunks have been loaded. You can now connect!");
    private static final String THANKS_MESSAGE = Cc.logO(Cc.WHITE, "Thank you for installing SkyGridx :)");

    public ChunkLoader(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadChunksAndRun(final Runnable task) {
        WorldManager.setupWorlds(this.plugin);
        if (this.plugin instanceof SkyGridPlugin) {
            ((SkyGridPlugin)this.plugin).setChunksLoading(true);
        }
        new BukkitRunnable(this){

            public void run() {
                Cc.logSB(WAIT_MESSAGE);
            }
        }.runTask((Plugin)this.plugin);
        final List worlds = Bukkit.getWorlds().stream().filter(w -> w.getName().startsWith("skygridx_")).collect(Collectors.toList());
        final int centerX = 0;
        final int centerZ = 0;
        final int chunkRange = 8;
        if (IS_PAPER) {
            CompletableFuture[] futures = (CompletableFuture[])worlds.stream().flatMap(world -> {
                CompletableFuture[] worldFuts = new CompletableFuture[(2 * chunkRange + 1) * (2 * chunkRange + 1)];
                int idx = 0;
                for (int dx = -chunkRange; dx <= chunkRange; ++dx) {
                    for (int dz = -chunkRange; dz <= chunkRange; ++dz) {
                        int cx = centerX + dx;
                        int cz = centerZ + dz;
                        Location loc = new Location(world, (double)(cx << 4), 0.0, (double)(cz << 4));
                        worldFuts[idx++] = world.getChunkAtAsync(loc).thenAccept(chunk -> {
                            world.loadChunk(cx, cz, false);
                            chunk.setForceLoaded(true);
                        });
                    }
                }
                return List.of(worldFuts).stream();
            }).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).thenRun(() -> this.finishLoading(task));
        } else {
            new BukkitRunnable(){

                public void run() {
                    for (World world : worlds) {
                        for (int dx = -chunkRange; dx <= chunkRange; ++dx) {
                            for (int dz = -chunkRange; dz <= chunkRange; ++dz) {
                                int cx = centerX + dx;
                                int cz = centerZ + dz;
                                world.loadChunk(cx, cz, false);
                                world.getChunkAt(cx, cz).setForceLoaded(true);
                            }
                        }
                    }
                    ChunkLoader.this.finishLoading(task);
                }
            }.runTask((Plugin)this.plugin);
        }
    }

    private void finishLoading(final Runnable task) {
        new BukkitRunnable(){

            public void run() {
                Cc.logSB(READY_MESSAGE);
                Cc.logSB(THANKS_MESSAGE);
                if (ChunkLoader.this.plugin instanceof SkyGridPlugin) {
                    ((SkyGridPlugin)ChunkLoader.this.plugin).setChunksLoading(false);
                }
                task.run();
            }
        }.runTask((Plugin)this.plugin);
    }

    private static boolean detectPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

